/*
 * Decompiled with CFR 0.152.
 */
package net.onelitefeather.antiredstoneclockremastered.injection;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import net.onelitefeather.antiredstoneclockremastered.AntiRedstoneClockRemastered;
import net.onelitefeather.antiredstoneclockremastered.api.PlotsquaredSupport;
import net.onelitefeather.antiredstoneclockremastered.api.WorldGuardSupport;
import net.onelitefeather.antiredstoneclockremastered.service.UpdateService;
import net.onelitefeather.antiredstoneclockremastered.service.api.NotificationService;
import net.onelitefeather.antiredstoneclockremastered.service.api.RedstoneClockService;
import net.onelitefeather.antiredstoneclockremastered.service.api.RegionService;
import net.onelitefeather.antiredstoneclockremastered.service.factory.RedstoneClockServiceFactory;
import net.onelitefeather.antiredstoneclockremastered.service.impl.AdminNotificationService;
import net.onelitefeather.antiredstoneclockremastered.service.impl.ConsoleNotificationService;
import net.onelitefeather.antiredstoneclockremastered.service.impl.DiscordNotificationService;
import net.onelitefeather.antiredstoneclockremastered.service.impl.SignNotificationService;
import net.onelitefeather.antiredstoneclockremastered.utils.CheckTPS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceModule
extends AbstractModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceModule.class);

    @Override
    protected void configure() {
        this.bind(UpdateService.class).in(Singleton.class);
        this.bind(CheckTPS.class).in(Singleton.class);
    }

    @Provides
    @Singleton
    public RedstoneClockService provideRedstoneClockService(AntiRedstoneClockRemastered plugin, RegionService regionService, PlotsquaredSupport plotsquaredSupport, WorldGuardSupport worldGuardSupport, NotificationService notificationService) {
        return RedstoneClockServiceFactory.createService(plugin, regionService, plotsquaredSupport, worldGuardSupport, notificationService);
    }

    @Provides
    @Singleton
    public NotificationService providesNotificationService(AntiRedstoneClockRemastered antiRedstoneClockRemastered, RegionService regionService) {
        AdminNotificationService adminNotifications = new AdminNotificationService(antiRedstoneClockRemastered, null);
        ConsoleNotificationService consoleNotification = new ConsoleNotificationService(antiRedstoneClockRemastered, adminNotifications);
        SignNotificationService signNotifications = new SignNotificationService(antiRedstoneClockRemastered, consoleNotification, regionService);
        DiscordNotificationService discordNotification = new DiscordNotificationService(antiRedstoneClockRemastered, signNotifications);
        return discordNotification;
    }
}

