/*
 * Decompiled with CFR 0.152.
 */
package xiao.cbraddon.config.common.game.zone;

import com.google.gson.JsonObject;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import xiao.battleroyale.BattleRoyale;
import xiao.battleroyale.api.algorithm.IAlgorithmApi;
import xiao.battleroyale.api.algorithm.IDistribution;
import xiao.battleroyale.api.algorithm.IRectangleGrid;
import xiao.battleroyale.util.JsonUtils;
import xiao.cbraddon.CbrAddon;
import xiao.cbraddon.config.common.game.zone.EntityFuncProtocol;

public class EntityFuncProtocol044 {
    private static final IAlgorithmApi algorithmApi = BattleRoyale.getAlgorithmApi();
    public static final String DISTRIBUTION_TYPE = "distributionType";
    public static final String LOOT_FACTOR_CONTRIBUTION = "lootFactorContribution";
    public static final String FIXED_SIMULATION = "fixedSimulation";
    public static final String ALLOW_ON_BORDER = "allowOnBorder";
    public static final String GLOBAL_SHRINK_RATIO = "globalShrinkRatio";
    public static final String NEED_SHUFFLE = "needShuffle";
    public static final String RANDOM_RANGE = "randomRange";
    public static final String FIND_GROUND = "findGround";
    public static final String LIMIT_TO_BOTTOM = "limitToBottom";
    public static final String LIMIT_TO_TOP = "limitToTop";
    public static final String ADDITIONAL_OFFSET = "additionalOffset";
    public static final String IGNORE_OUTSIDE = "ignoreOutside";
    public static final String RELATIVE_MOVEMENT_RANDOM_RANGE = "relativeMovementRandomRange";

    protected static EntityFuncProtocol fromTag(@NotNull JsonObject jsonTag) {
        try {
            IRectangleGrid distribution = switch (JsonUtils.getJsonString((JsonObject)jsonTag, (String)DISTRIBUTION_TYPE, (String)"")) {
                case "rectangleGrid" -> algorithmApi.rectangleGrid();
                case "goldenSpiral" -> algorithmApi.golderSpiral();
                case "circleGrid" -> algorithmApi.circleGrid();
                default -> algorithmApi.circleGrid();
            };
            double lootFactor = JsonUtils.getJsonDouble((JsonObject)jsonTag, (String)LOOT_FACTOR_CONTRIBUTION, (double)1.0);
            int fixedSimulation = JsonUtils.getJsonInt((JsonObject)jsonTag, (String)FIXED_SIMULATION, (int)0);
            boolean allowOnBorder = JsonUtils.getJsonBool((JsonObject)jsonTag, (String)ALLOW_ON_BORDER, (boolean)false);
            double globalShrinkRatio = JsonUtils.getJsonDouble((JsonObject)jsonTag, (String)GLOBAL_SHRINK_RATIO, (double)1.0);
            boolean needShuffle = JsonUtils.getJsonBool((JsonObject)jsonTag, (String)NEED_SHUFFLE, (boolean)false);
            Vec3 randomRange = JsonUtils.getJsonVec((JsonObject)jsonTag, (String)RANDOM_RANGE, (Vec3)Vec3.ZERO);
            boolean findGround = JsonUtils.getJsonBool((JsonObject)jsonTag, (String)FIND_GROUND, (boolean)false);
            boolean limitToBottom = JsonUtils.getJsonBool((JsonObject)jsonTag, (String)LIMIT_TO_BOTTOM, (boolean)true);
            boolean limitToTop = JsonUtils.getJsonBool((JsonObject)jsonTag, (String)LIMIT_TO_TOP, (boolean)false);
            Vec3 additionalOffset = JsonUtils.getJsonVec((JsonObject)jsonTag, (String)ADDITIONAL_OFFSET, (Vec3)Vec3.ZERO);
            boolean ignoreOutside = JsonUtils.getJsonBool((JsonObject)jsonTag, (String)IGNORE_OUTSIDE, (boolean)false);
            Vec3 relativeMovementRandomRange = JsonUtils.getJsonVec((JsonObject)jsonTag, (String)RELATIVE_MOVEMENT_RANDOM_RANGE, (Vec3)Vec3.ZERO);
            return new EntityFuncProtocol((IDistribution)distribution, lootFactor, fixedSimulation, allowOnBorder, globalShrinkRatio, needShuffle, randomRange, findGround, limitToBottom, limitToTop, additionalOffset, ignoreOutside, relativeMovementRandomRange);
        }
        catch (Exception e) {
            CbrAddon.LOGGER.debug("EntityFuncProtocol044: Failed to parse by cbra:0.4.4 protocol from jsonTag: {}", (Object)jsonTag, (Object)e);
            return null;
        }
    }
}

