/*
 * Decompiled with CFR 0.152.
 */
package xiao.cbraddon.event.game;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import xiao.battleroyale.api.event.CustomEventType;
import xiao.battleroyale.api.event.ICustomEvent;
import xiao.battleroyale.api.event.ICustomEventHandler;
import xiao.battleroyale.api.event.game.zone.EntityEvent;
import xiao.battleroyale.api.game.IGameManager;
import xiao.battleroyale.api.game.zone.gamezone.IGameZone;
import xiao.battleroyale.common.game.zone.ZoneManager;
import xiao.battleroyale.util.Vec3Utils;
import xiao.cbraddon.CbrAddon;
import xiao.cbraddon.config.common.game.zone.EntityFuncProtocol;

public class EntityFuncHandler
implements ICustomEventHandler {
    public static EntityFuncHandler get() {
        return EntityFuncHandlerHolder.INSTANCE;
    }

    private EntityFuncHandler() {
    }

    public String getEventHandlerName() {
        return "cbra:EntityFuncHandler";
    }

    public void handleEvent(CustomEventType customEventType, ICustomEvent customEvent) {
        if (customEventType == CustomEventType.ENTITY_EVENT) {
            int pendingSize;
            int i;
            EntityEvent entityEvent = (EntityEvent)customEvent;
            EntityFuncProtocol entityFuncProtocol = EntityFuncProtocol.getConfigFromProtocol(entityEvent.getProtocol(), entityEvent.getJsonTag());
            if (entityFuncProtocol == null) {
                return;
            }
            IGameManager gameManager = entityEvent.getGameManager();
            ZoneManager.ZoneTickContext zoneTickContext = entityEvent.getZoneTickContext();
            ServerLevel serverLevel = gameManager.getServerLevel();
            int zoneId = zoneTickContext.zoneId;
            IGameZone gameZone = (IGameZone)zoneTickContext.gameZones.get(zoneId);
            if (gameZone == null) {
                return;
            }
            if (!gameZone.isDetermined()) {
                return;
            }
            double shapeProgress = gameZone.getShapeProgress(zoneTickContext.gameTime);
            Vec3 zoneCenter = gameZone.getCenterPos(shapeProgress);
            Vec3 zoneDimension = gameZone.getDimension(shapeProgress);
            assert (zoneCenter != null);
            assert (zoneDimension != null);
            List lootEntities = entityEvent.getLootEntities();
            int minSimulation = (int)((double)lootEntities.size() * entityFuncProtocol.lootFactor + (double)entityFuncProtocol.fixedSimulation);
            ArrayList<Vec3> pendingPos = entityFuncProtocol.distribution.distributed(zoneCenter, zoneDimension, minSimulation, entityFuncProtocol.allowOnBorder, entityFuncProtocol.globalShrinkRatio);
            if (entityFuncProtocol.needShuffle) {
                Collections.shuffle(pendingPos, CbrAddon.COMMON_RANDOM);
            }
            if (entityFuncProtocol.randomRange != Vec3.ZERO) {
                pendingPos.replaceAll(v -> Vec3Utils.randomAdjustXYZ((Vec3)v, (Vec3)entityFuncProtocol.randomRange, (Supplier)zoneTickContext.random));
            }
            if (entityFuncProtocol.findGround) {
                Double zoneTopHeight = gameZone.getTopCenterPos(shapeProgress);
                Double zoneBottomHeight = gameZone.getBottomCenterPos(shapeProgress);
                assert (zoneTopHeight != null);
                assert (zoneBottomHeight != null);
                for (i = 0; i < pendingPos.size(); ++i) {
                    Vec3 basePos = (Vec3)pendingPos.get(i);
                    BlockPos lookupPos = new BlockPos((int)basePos.x, (int)zoneTopHeight.doubleValue(), (int)basePos.z);
                    int groundY = serverLevel.getHeight(Heightmap.Types.MOTION_BLOCKING, lookupPos.getX(), lookupPos.getZ());
                    double targetY = groundY + 1;
                    if (targetY < (double)(serverLevel.dimensionType().minY() + 2)) {
                        CbrAddon.LOGGER.debug("EntityFuncHandler attempt to use invalid targetY {}", (Object)targetY);
                    }
                    if (targetY < zoneBottomHeight && entityFuncProtocol.limitToBottom) {
                        targetY = zoneBottomHeight;
                    }
                    if (targetY > zoneTopHeight && entityFuncProtocol.limitToTop) {
                        targetY = zoneTopHeight;
                    }
                    pendingPos.set(i, new Vec3(basePos.x, targetY, basePos.z));
                }
            }
            if (entityFuncProtocol.additionalOffset != Vec3.ZERO) {
                pendingPos.replaceAll(v -> v.add(entityFuncProtocol.additionalOffset));
            }
            if (entityFuncProtocol.ignoreOutside) {
                ArrayList<Vec3> inside = new ArrayList<Vec3>(pendingPos.size());
                for (Vec3 pos : pendingPos) {
                    if (!gameZone.isWithinZone(pos, shapeProgress)) continue;
                    inside.add(pos);
                }
                if (pendingPos.size() != inside.size()) {
                    pendingPos.clear();
                    pendingPos = inside;
                }
            }
            if ((pendingSize = pendingPos.size()) == 0) {
                CbrAddon.LOGGER.warn("EntityFuncHandler: pendingSize == 0, add Vec3.ZERO");
                pendingPos.add(Vec3.ZERO);
                pendingSize = 1;
            }
            boolean doRelativeMovement = entityFuncProtocol.relativeMovementRange != Vec3.ZERO;
            for (i = 0; i < lootEntities.size(); ++i) {
                Entity entity = (Entity)lootEntities.get(i);
                try {
                    TagValueOutput output = TagValueOutput.createWithContext((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)zoneTickContext.serverLevel.registryAccess());
                    if (entity.save((ValueOutput)output)) {
                        CompoundTag nbt = entityEvent.getNbt().copy();
                        block15: for (String key : nbt.keySet()) {
                            Tag tag = nbt.get(key);
                            switch (tag.getId()) {
                                case 1: {
                                    output.putByte(key, ((Byte)tag.asByte().get()).byteValue());
                                    continue block15;
                                }
                                case 2: {
                                    output.putShort(key, ((Short)tag.asShort().get()).shortValue());
                                    continue block15;
                                }
                                case 3: {
                                    output.putInt(key, ((Integer)tag.asInt().get()).intValue());
                                    continue block15;
                                }
                                case 4: {
                                    output.putLong(key, ((Long)tag.asLong().get()).longValue());
                                    continue block15;
                                }
                                case 5: {
                                    output.putFloat(key, ((Float)tag.asFloat().get()).floatValue());
                                    continue block15;
                                }
                                case 6: {
                                    output.putDouble(key, ((Double)tag.asDouble().get()).doubleValue());
                                    continue block15;
                                }
                                case 8: {
                                    output.putString(key, (String)tag.asString().get());
                                    continue block15;
                                }
                                case 9: 
                                case 11: 
                                case 12: {
                                    output.putIntArray(key, tag.asIntArray().orElse(new int[0]));
                                    continue block15;
                                }
                            }
                            CbrAddon.LOGGER.info("EntityFuncHandler: nbt.get({}).getId() = {} unhandled", (Object)key, (Object)tag.getId());
                        }
                        CompoundTag entityNbt = output.buildResult();
                        ValueInput input = TagValueInput.create((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)zoneTickContext.serverLevel.registryAccess(), (CompoundTag)entityNbt);
                        entity.load(input);
                    } else {
                        CbrAddon.LOGGER.debug("EntityFuncHandler: entity.save() return false");
                    }
                }
                catch (Exception e) {
                    CbrAddon.LOGGER.error("EntityFuncHandler: An error occurred during writing nbt to entity: {}", (Object)e.getMessage());
                }
                entity.setPos((Vec3)pendingPos.get(i % pendingSize));
                if (!doRelativeMovement) continue;
                Vec3 baseMovement = entity.getDeltaMovement();
                entity.setDeltaMovement(Vec3Utils.randomAdjustXYZ((Vec3)baseMovement, (Vec3)entityFuncProtocol.relativeMovementRange, (Supplier)zoneTickContext.random));
            }
        } else {
            CbrAddon.LOGGER.warn("{} received wrong custom event type: {}", (Object)this.getEventHandlerName(), (Object)customEventType);
        }
    }

    private static class EntityFuncHandlerHolder {
        private static final EntityFuncHandler INSTANCE = new EntityFuncHandler();

        private EntityFuncHandlerHolder() {
        }
    }
}

