/*
 * Decompiled with CFR 0.152.
 */
package xiao.cbraddon.config.common.game.zone;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import xiao.battleroyale.BattleRoyale;
import xiao.battleroyale.api.algorithm.IAlgorithmApi;
import xiao.battleroyale.api.algorithm.IDistribution;
import xiao.battleroyale.api.algorithm.IRectangleGrid;
import xiao.battleroyale.util.StringUtils;
import xiao.cbraddon.CbrAddon;
import xiao.cbraddon.config.common.game.zone.EntityFuncProtocol;

public class EntityFuncProtocol044 {
    private static final IAlgorithmApi algorithmApi = BattleRoyale.getAlgorithmApi();
    public static final String DISTRIBUTION_TYPE = "distributionType";
    public static final String LOOT_FACTOR_CONTRIBUTION = "lootFactorContribution";
    public static final String FIXED_SIMULATION = "fixedSimulation";
    public static final String ALLOW_ON_BORDER = "allowOnBorder";
    public static final String GLOBAL_SHRINK_RATIO = "globalShrinkRatio";
    public static final String NEED_SHUFFLE = "needShuffle";
    public static final String RANDOM_RANGE = "randomRange";
    public static final String FIND_GROUND = "findGround";
    public static final String LIMIT_TO_BOTTOM = "limitToBottom";
    public static final String LIMIT_TO_TOP = "limitToTop";
    public static final String ADDITIONAL_OFFSET = "additionalOffset";
    public static final String IGNORE_OUTSIDE = "ignoreOutside";
    public static final String RELATIVE_MOVEMENT_RANDOM_RANGE = "relativeMovementRandomRange";

    protected static EntityFuncProtocol fromTag(@NotNull CompoundTag tag) {
        try {
            IRectangleGrid distribution = switch (tag.m_128441_(DISTRIBUTION_TYPE) ? tag.m_128461_(DISTRIBUTION_TYPE) : "") {
                case "rectangleGrid" -> algorithmApi.rectangleGrid();
                case "goldenSpiral" -> algorithmApi.golderSpiral();
                case "circleGrid" -> algorithmApi.circleGrid();
                default -> algorithmApi.circleGrid();
            };
            double lootFactor = tag.m_128441_(LOOT_FACTOR_CONTRIBUTION) ? tag.m_128459_(LOOT_FACTOR_CONTRIBUTION) : 1.0;
            int fixedSimulation = tag.m_128441_(FIXED_SIMULATION) ? tag.m_128451_(FIXED_SIMULATION) : 0;
            boolean allowOnBorder = tag.m_128441_(ALLOW_ON_BORDER) ? tag.m_128471_(ALLOW_ON_BORDER) : false;
            double globalShrinkRatio = tag.m_128441_(GLOBAL_SHRINK_RATIO) ? tag.m_128459_(GLOBAL_SHRINK_RATIO) : 1.0;
            boolean needShuffle = tag.m_128441_(NEED_SHUFFLE) ? tag.m_128471_(NEED_SHUFFLE) : false;
            Vec3 randomRange = tag.m_128441_(RANDOM_RANGE) ? StringUtils.parseVectorString((String)tag.m_128461_(RANDOM_RANGE)) : Vec3.f_82478_;
            boolean findGround = tag.m_128441_(FIND_GROUND) ? tag.m_128471_(FIND_GROUND) : false;
            boolean limitToBottom = tag.m_128441_(LIMIT_TO_BOTTOM) ? tag.m_128471_(LIMIT_TO_BOTTOM) : true;
            boolean limitToTop = tag.m_128441_(LIMIT_TO_TOP) ? tag.m_128471_(LIMIT_TO_TOP) : false;
            Vec3 additionalOffset = tag.m_128441_(ADDITIONAL_OFFSET) ? StringUtils.parseVectorString((String)tag.m_128461_(ADDITIONAL_OFFSET)) : Vec3.f_82478_;
            boolean ignoreOutside = tag.m_128441_(IGNORE_OUTSIDE) ? tag.m_128471_(IGNORE_OUTSIDE) : false;
            Vec3 relativeMovementRandomRange = tag.m_128441_(RELATIVE_MOVEMENT_RANDOM_RANGE) ? StringUtils.parseVectorString((String)tag.m_128461_(RELATIVE_MOVEMENT_RANDOM_RANGE)) : Vec3.f_82478_;
            return new EntityFuncProtocol((IDistribution)distribution, lootFactor, fixedSimulation, allowOnBorder, globalShrinkRatio, needShuffle, randomRange, findGround, limitToBottom, limitToTop, additionalOffset, ignoreOutside, relativeMovementRandomRange);
        }
        catch (Exception e) {
            CbrAddon.LOGGER.debug("EntityFuncProtocol044: Failed to parse by cbra:0.4.4 protocol from tag: {}", (Object)tag, (Object)e);
            return null;
        }
    }
}

