/*
 * Decompiled with CFR 0.152.
 */
package net.salju.supernatural.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.salju.supernatural.init.SupernaturalBlocks;
import net.salju.supernatural.init.SupernaturalTags;

public class RitualBlockEntity
extends BaseContainerBlockEntity {
    private NonNullList<ItemStack> stacks = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
    private boolean greedy;
    private int timer = 0;

    public RitualBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SupernaturalBlocks.RITUAL.get(), pos, state);
    }

    public void saveAdditional(ValueOutput tag) {
        super.saveAdditional(tag);
        ContainerHelper.saveAllItems((ValueOutput)tag, this.stacks, (boolean)true);
        tag.putBoolean("Greedy", this.greedy);
    }

    public void loadAdditional(ValueInput tag) {
        super.loadAdditional(tag);
        this.stacks = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((ValueInput)tag, this.stacks);
        this.greedy = tag.getBooleanOr("Greedy", false);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection queen, ValueInput tag) {
        this.stacks = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((ValueInput)tag, this.stacks);
        this.greedy = tag.getBooleanOr("Greedy", false);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider regs) {
        TagValueOutput value = TagValueOutput.createWithContext((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)regs);
        ContainerHelper.saveAllItems((ValueOutput)value, this.stacks, (boolean)true);
        CompoundTag tag = value.buildResult();
        tag.putBoolean("Greedy", this.greedy);
        return tag;
    }

    public Component getDefaultName() {
        return Component.translatable((String)"block.supernatural.ritual_altar");
    }

    public AbstractContainerMenu createMenu(int i, Inventory bag) {
        return null;
    }

    protected NonNullList<ItemStack> getItems() {
        return this.stacks;
    }

    protected void setItems(NonNullList<ItemStack> items) {
        this.stacks = items;
    }

    public int getContainerSize() {
        return this.stacks.size();
    }

    public int getMaxStackSize() {
        return 1;
    }

    public boolean isEmpty() {
        return this.getItem(0).isEmpty();
    }

    public boolean stillValid(Player player) {
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player);
    }

    public ItemStack getItem(int i) {
        return (ItemStack)this.stacks.get(i);
    }

    public boolean canPlaceItem(int i, ItemStack stack) {
        return this.isEmpty();
    }

    public ItemStack removeItemNoUpdate(int i) {
        return this.getItem(i).is(SupernaturalTags.KEPT) || this.getGreedy() ? ItemStack.EMPTY : ContainerHelper.takeItem(this.stacks, (int)i);
    }

    public ItemStack removeItem(int i, int e) {
        this.updateBlock();
        return this.getItem(i).is(SupernaturalTags.KEPT) || this.getGreedy() ? ItemStack.EMPTY : ContainerHelper.removeItem(this.stacks, (int)i, (int)e);
    }

    public void setItem(int i, ItemStack stack) {
        this.stacks.set(i, (Object)stack.copy());
        this.getItem(i).setCount(1);
        this.updateBlock();
    }

    public void clearContent() {
        this.stacks.clear();
        this.updateBlock();
    }

    public void updateBlock() {
        this.setChanged();
        this.getLevel().updateNeighborsAt(this.getBlockPos(), this.getBlockState().getBlock());
        this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }

    public void dropItem(int i) {
        if (!this.getGreedy()) {
            Containers.dropItemStack((Level)this.getLevel(), (double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ(), (ItemStack)this.getItem(i));
            this.updateBlock();
        }
    }

    public void cloneItem(ItemStack stack) {
        Containers.dropItemStack((Level)this.getLevel(), (double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ(), (ItemStack)stack);
    }

    public void setGreedy(boolean check) {
        this.greedy = check;
    }

    public boolean getGreedy() {
        return this.greedy;
    }

    public static void tick(Level world, BlockPos pos, BlockState state, RitualBlockEntity target) {
        if (world instanceof ServerLevel) {
            ServerLevel lvl = (ServerLevel)world;
            if (!target.isEmpty()) {
                ++target.timer;
                if (target.timer >= 5) {
                    lvl.sendParticles((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 2, 0.1, 0.15, 0.1, 0.0);
                    target.timer = 0;
                }
            }
        }
    }
}

