/*
 * Decompiled with CFR 0.152.
 */
package net.salju.supernatural.client.model;

import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.ArmorModelSet;

public class GothicArmorModel
extends HumanoidModel {
    public static ArmorModelSet<LayerDefinition> GOTHIC_ARMOR_LAYER = GothicArmorModel.createArmorSet().map(mesh -> LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)32));

    public GothicArmorModel(ModelPart root) {
        super(root);
    }

    public static LayerDefinition createHeadLayer() {
        return (LayerDefinition)GOTHIC_ARMOR_LAYER.head();
    }

    public static LayerDefinition createBodyLayer() {
        return (LayerDefinition)GOTHIC_ARMOR_LAYER.chest();
    }

    public static LayerDefinition createLegsLayer() {
        return (LayerDefinition)GOTHIC_ARMOR_LAYER.legs();
    }

    public static LayerDefinition createBootsLayer() {
        return (LayerDefinition)GOTHIC_ARMOR_LAYER.feet();
    }

    public static ArmorModelSet<MeshDefinition> createArmorSet() {
        return GothicArmorModel.createArmorSet(GothicArmorModel::createBaseArmor);
    }

    public static ArmorModelSet<MeshDefinition> createArmorSet(Function<CubeDeformation, MeshDefinition> base) {
        MeshDefinition head = base.apply(new CubeDeformation(1.0f));
        head.getRoot().retainPartsAndChildren(Set.of("head"));
        MeshDefinition body = base.apply(new CubeDeformation(1.0f));
        body.getRoot().retainExactParts(Set.of("body", "left_arm", "right_arm"));
        MeshDefinition legs = base.apply(new CubeDeformation(1.0f));
        legs.getRoot().retainExactParts(Set.of("left_leg", "right_leg", "body"));
        MeshDefinition boots = base.apply(new CubeDeformation(1.0f));
        boots.getRoot().retainExactParts(Set.of("left_leg", "right_leg"));
        return new ArmorModelSet((Object)head, (Object)body, (Object)legs, (Object)boots);
    }

    private static MeshDefinition createBaseArmor(CubeDeformation cube) {
        MeshDefinition mesh = HumanoidModel.createMesh((CubeDeformation)cube, (float)0.0f);
        PartDefinition root = mesh.getRoot();
        root.getChild("head").addOrReplaceChild("feather", CubeListBuilder.create().texOffs(25, -7).addBox(0.0f, -14.0f, 2.0f, 0.0f, 7.0f, 7.0f, cube.extend(-1.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        return mesh;
    }
}

