/*
 * Decompiled with CFR 0.152.
 */
package net.salju.supernatural.client.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;
import net.salju.supernatural.client.renderer.SpookyState;

public class SpiritModel<T extends SpookyState>
extends EntityModel<T> {
    private final ModelPart body;
    private final ModelPart rightArm;
    private final ModelPart leftArm;
    private final ModelPart rightWing;
    private final ModelPart leftWing;
    private final ModelPart head;

    public SpiritModel(ModelPart rwt) {
        super(rwt.getChild("root"), RenderType::entityTranslucent);
        this.body = this.root.getChild("body");
        this.rightArm = this.body.getChild("right_arm");
        this.leftArm = this.body.getChild("left_arm");
        this.rightWing = this.body.getChild("right_wing");
        this.leftWing = this.body.getChild("left_wing");
        this.head = this.root.getChild("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition base = mesh.getRoot();
        PartDefinition root = base.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-2.5f, (float)0.0f));
        root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, -5.0f, -2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)20.0f, (float)0.0f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 10).addBox(-1.5f, 0.0f, -1.0f, 3.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 16).addBox(-1.5f, 1.0f, -1.0f, 3.0f, 5.0f, 2.0f, new CubeDeformation(-0.2f)), PartPose.offset((float)0.0f, (float)20.0f, (float)0.0f));
        body.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(23, 0).addBox(-1.25f, -0.5f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(-0.1f)), PartPose.offset((float)-1.75f, (float)0.25f, (float)0.0f));
        body.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(23, 6).addBox(-0.75f, -0.5f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(-0.1f)), PartPose.offset((float)1.75f, (float)0.25f, (float)0.0f));
        body.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(16, 14).mirror().addBox(0.0f, 0.0f, 0.0f, 0.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.5f, (float)1.0f, (float)1.0f));
        body.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(16, 14).addBox(0.0f, 0.0f, 0.0f, 0.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.5f, (float)1.0f, (float)1.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)32, (int)32);
    }

    public void setupAnim(T spirit) {
        float f12;
        this.root().getAllParts().forEach(ModelPart::resetPose);
        float f = ((SpookyState)((Object)spirit)).ageInTicks * 20.0f * ((float)Math.PI / 180) + ((SpookyState)((Object)spirit)).walkAnimationSpeed;
        float f1 = Mth.cos((float)f) * (float)Math.PI * 0.15f;
        float f3 = ((SpookyState)((Object)spirit)).ageInTicks * 9.0f * ((float)Math.PI / 180);
        float f4 = Math.min(((SpookyState)((Object)spirit)).walkAnimationSpeed / 0.3f, 1.0f);
        float f5 = 1.0f - f4;
        this.head.xRot = ((SpookyState)((Object)spirit)).xRot * ((float)Math.PI / 180);
        this.head.yRot = ((SpookyState)((Object)spirit)).yRot * ((float)Math.PI / 180);
        this.rightWing.xRot = 0.43633232f;
        this.rightWing.yRot = -0.61086524f + f1;
        this.leftWing.xRot = 0.43633232f;
        this.leftWing.yRot = 0.61086524f - f1;
        this.body.xRot = f12 = f4 * 0.6981317f;
        float f13 = Mth.lerp((float)f4, (float)f12, (float)Mth.lerp((float)f4, (float)-1.0471976f, (float)-0.7853982f));
        this.root.y += (float)Math.cos(f3) * 0.25f * f5;
        this.rightArm.xRot = f13;
        this.leftArm.xRot = f13;
        float f14 = f5 * (1.0f - f4);
        float f15 = 0.43633232f - Mth.cos((float)(f3 + 4.712389f)) * (float)Math.PI * 0.075f * f14;
        this.leftArm.zRot = -f15;
        this.rightArm.zRot = f15;
        this.rightArm.yRot = 0.27925268f * f4;
        this.leftArm.yRot = -0.27925268f * f4;
        if (((SpookyState)((Object)spirit)).isAggressive) {
            this.rightArm.xRot = 4.712389f;
            this.leftArm.xRot = 4.712389f;
        }
    }
}

