/*
 * Decompiled with CFR 0.152.
 */
package net.salju.supernatural.entity;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.salju.supernatural.entity.AbstractMinionEntity;
import net.salju.supernatural.entity.PossessedArmor;
import net.salju.supernatural.entity.ai.targets.SpookyAttackSelector;
import net.salju.supernatural.events.SupernaturalManager;
import net.salju.supernatural.init.SupernaturalConfig;
import net.salju.supernatural.init.SupernaturalEffects;
import net.salju.supernatural.init.SupernaturalMobs;
import net.salju.supernatural.init.SupernaturalSounds;

public class Spooky
extends AbstractMinionEntity {
    public Spooky(EntityType<Spooky> type, Level world) {
        super(type, world);
        this.moveControl = new FlyingMoveControl((Mob)this, 20, true);
    }

    protected PathNavigation createNavigation(Level lvl) {
        return new FlyingPathNavigation((Mob)this, lvl);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.8, false));
        this.goalSelector.addGoal(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(4, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.2));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 8.0f));
        this.targetSelector.addGoal(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 12, true, true, (TargetingConditions.Selector)new SpookyAttackSelector(this)));
    }

    public SoundEvent getAmbientSound() {
        return SoundEvents.VEX_AMBIENT;
    }

    public SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.VEX_HURT;
    }

    public SoundEvent getDeathSound() {
        return SoundEvents.VEX_DEATH;
    }

    @Override
    public void aiStep() {
        super.aiStep();
        this.setNoGravity(true);
    }

    public boolean doHurtTarget(ServerLevel lvl, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            target.addEffect(new MobEffectInstance(SupernaturalEffects.POSSESSION, 6000, 0));
            target.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 32, 0, false, false));
            this.playSound((SoundEvent)SupernaturalSounds.SPOOK_POOF.get(), 1.0f, 1.0f);
            this.discard();
            double r = this.random.nextGaussian() * 0.02;
            lvl.sendParticles((ParticleOptions)ParticleTypes.POOF, this.getRandomX(1.0), this.getRandomY(), this.getRandomZ(1.0), 10, r, r, r, 0.25);
        }
        return super.doHurtTarget(lvl, entity);
    }

    public void baseTick() {
        ServerLevel lvl;
        Level target;
        Level level;
        super.baseTick();
        if (((Boolean)SupernaturalConfig.ARMOR.get()).booleanValue() && (level = this.level()) instanceof ServerLevel && (target = (ArmorStand)(lvl = (ServerLevel)level).getNearestEntity(ArmorStand.class, TargetingConditions.DEFAULT, (LivingEntity)this, this.getX(), this.getY(), this.getZ(), this.getBoundingBox().inflate(0.85))) != null && SupernaturalManager.hasArmor((LivingEntity)target)) {
            this.playSound((SoundEvent)SupernaturalSounds.SPOOK_POOF.get(), 1.0f, 1.0f);
            PossessedArmor armor = (PossessedArmor)((Object)SupernaturalManager.convertArmor((ArmorStand)target, (EntityType)SupernaturalMobs.POSSESSED_ARMOR.get(), true));
            if (this.getOwner() != null) {
                ItemStack sword = new ItemStack((ItemLike)Items.IRON_SWORD);
                EnchantmentHelper.enchantItem((RandomSource)this.getRandom(), (ItemStack)sword, (int)32, (RegistryAccess)lvl.registryAccess(), Optional.empty());
                armor.setOwnerDirectly(this.getOwner());
                armor.setItemSlot(EquipmentSlot.MAINHAND, sword);
            }
            double r = this.random.nextGaussian() * 0.02;
            lvl.sendParticles((ParticleOptions)ParticleTypes.POOF, this.getRandomX(1.0), this.getRandomY(), this.getRandomZ(1.0), 10, r, r, r, 0.25);
            this.discard();
        }
        if (this.isAlive()) {
            if (this.getTarget() != null && this.getTarget().isAlive() && (this.getTarget().hasEffect(MobEffects.GLOWING) || this.getTarget().hasEffect(SupernaturalEffects.POSSESSION))) {
                this.setTarget(null);
            }
            if ((target = this.level()) instanceof ServerLevel) {
                lvl = (ServerLevel)target;
                if (!this.isTamed() && this.level().isBrightOutside() && this.level().canSeeSkyFromBelowWater(BlockPos.containing((double)this.getX(), (double)this.getY(), (double)this.getZ()))) {
                    this.playSound((SoundEvent)SupernaturalSounds.SPOOK_POOF.get(), 1.0f, 1.0f);
                    this.discard();
                    double r = this.random.nextGaussian() * 0.02;
                    lvl.sendParticles((ParticleOptions)ParticleTypes.POOF, this.getRandomX(1.0), this.getRandomY(), this.getRandomZ(1.0), 10, r, r, r, 0.25);
                }
            }
        }
    }

    protected float getSoundVolume() {
        return 0.35f;
    }

    public boolean causeFallDamage(double d, float f, DamageSource source) {
        return false;
    }

    public void setNoGravity(boolean check) {
        super.setNoGravity(true);
    }
}

