/*
 * Decompiled with CFR 0.152.
 */
package net.salju.supernatural.entity.ai.spells;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.salju.supernatural.Supernatural;
import net.salju.supernatural.entity.Vampire;
import net.salju.supernatural.entity.ai.MinionTargetGoal;
import net.salju.supernatural.entity.ai.spells.AbstractSupernaturalSpellGoal;
import net.salju.supernatural.init.SupernaturalMobs;

public class SupernaturalNecroSpellGoal
extends AbstractSupernaturalSpellGoal {
    private final Monster user;

    public SupernaturalNecroSpellGoal(Monster source) {
        super(source);
        this.user = source;
    }

    @Override
    protected void performSpellCasting() {
        LivingEntity target = this.user.getTarget();
        double x = target.getX();
        double y = target.getY();
        double z = target.getZ();
        BlockPos pos = BlockPos.containing((double)(x + 0.5), (double)y, (double)(z + 0.5));
        Level level = target.level();
        if (level instanceof ServerLevel) {
            ServerLevel lvl = (ServerLevel)level;
            Supernatural.queueServerWork(25, () -> {
                LightningBolt bolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create((Level)lvl, EntitySpawnReason.EVENT);
                bolt.move(MoverType.SELF, Vec3.atBottomCenterOf((Vec3i)pos));
                bolt.setVisualOnly(true);
                lvl.addFreshEntity((Entity)bolt);
                if (target.getX() == x && target.getY() == y && target.getZ() == z) {
                    target.hurt(target.damageSources().magic(), 12.0f);
                } else {
                    for (int bob = 0; bob < 2; ++bob) {
                        if (Math.random() <= 0.99) {
                            if (Math.random() <= 0.5) {
                                Skeleton skele = (Skeleton)EntityType.SKELETON.spawn(lvl, pos, EntitySpawnReason.MOB_SUMMONED);
                                skele.targetSelector.addGoal(1, (Goal)new MinionTargetGoal((PathfinderMob)skele, (LivingEntity)this.user));
                                continue;
                            }
                            Zombie billy = (Zombie)EntityType.ZOMBIE.spawn(lvl, pos, EntitySpawnReason.MOB_SUMMONED);
                            billy.targetSelector.addGoal(1, (Goal)new MinionTargetGoal((PathfinderMob)billy, (LivingEntity)this.user));
                            continue;
                        }
                        Vampire vampire = (Vampire)((EntityType)SupernaturalMobs.VAMPIRE.get()).spawn(lvl, pos, EntitySpawnReason.MOB_SUMMONED);
                        vampire.setCustomName((Component)Component.literal((String)"Bob"));
                    }
                }
            });
        }
    }

    @Override
    protected int getCastingTime() {
        return 40;
    }

    @Override
    protected int getCastingInterval() {
        return 420;
    }

    @Override
    protected int getSpell() {
        return 2;
    }

    @Override
    protected SoundEvent getSpellPrepareSound() {
        return SoundEvents.EVOKER_PREPARE_ATTACK;
    }
}

