/*
 * Decompiled with CFR 0.152.
 */
package net.salju.supernatural.item;

import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.salju.supernatural.init.SupernaturalData;
import net.salju.supernatural.init.SupernaturalItems;
import net.salju.supernatural.init.SupernaturalTags;
import net.salju.supernatural.item.component.RitualCompassData;

public class RitualCompassItem
extends Item {
    public RitualCompassItem(Item.Properties props) {
        super(props);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay display, Consumer<Component> list, TooltipFlag flag) {
        super.appendHoverText(stack, context, display, list, flag);
        RitualCompassData data = (RitualCompassData)stack.get(SupernaturalData.COMPASS);
        if (data != null) {
            if (context.level().dimensionType().natural()) {
                list.accept((Component)Component.translatable((String)data.getPower()).withStyle(ChatFormatting.DARK_PURPLE));
            } else {
                list.accept((Component)Component.translatable((String)"desc.compass.broken").withStyle(ChatFormatting.DARK_PURPLE));
            }
        } else {
            list.accept((Component)Component.translatable((String)"desc.compass.creative").withStyle(ChatFormatting.DARK_PURPLE));
        }
    }

    public InteractionResult use(Level world, Player player, InteractionHand hand) {
        if (player.isCreative() && world.dimensionType().natural()) {
            if (world instanceof ServerLevel) {
                ServerLevel lvl = (ServerLevel)world;
                player.setItemInHand(hand, RitualCompassItem.getRitualCompass(player.blockPosition(), lvl, Mth.nextInt((RandomSource)player.getRandom(), (int)0, (int)2)));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static ItemStack getRitualCompass(BlockPos pos, ServerLevel lvl, int i) {
        ItemStack stack = new ItemStack((ItemLike)SupernaturalItems.COMPASS.get());
        if (i <= 0) {
            BlockPos loc = lvl.findNearestMapStructure(SupernaturalTags.RUINS, pos, 100, false);
            if (loc != null) {
                stack.set(SupernaturalData.COMPASS, (Object)new RitualCompassData(Optional.of(GlobalPos.of((ResourceKey)lvl.dimension(), (BlockPos)loc)), "desc.compass.ruins"));
            }
        } else if (i >= 2) {
            BlockPos loc = lvl.findNearestMapStructure(SupernaturalTags.ANCIENT, pos, 100, false);
            if (loc != null) {
                stack.set(SupernaturalData.COMPASS, (Object)new RitualCompassData(Optional.of(GlobalPos.of((ResourceKey)lvl.dimension(), (BlockPos)loc)), "desc.compass.ancient"));
            }
        } else {
            BlockPos loc = lvl.findNearestMapStructure(SupernaturalTags.LIFE, pos, 100, false);
            if (loc != null) {
                stack.set(SupernaturalData.COMPASS, (Object)new RitualCompassData(Optional.of(GlobalPos.of((ResourceKey)lvl.dimension(), (BlockPos)loc)), "desc.compass.village"));
            }
        }
        return stack;
    }
}

