/*
 * Decompiled with CFR 0.152.
 */
package net.salju.supernatural.item;

import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.salju.supernatural.events.SupernaturalManager;
import net.salju.supernatural.init.SupernaturalData;
import net.salju.supernatural.init.SupernaturalItems;
import net.salju.supernatural.init.SupernaturalTags;
import net.salju.supernatural.item.component.SoulgemData;

public class SoulgemItem
extends Item {
    public SoulgemItem(Item.Properties props) {
        super(props);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay display, Consumer<Component> list, TooltipFlag flag) {
        super.appendHoverText(stack, context, display, list, flag);
        if (context.level() != null) {
            Entity entity = EntityType.loadEntityRecursive((CompoundTag)SupernaturalManager.getSoulTag(stack), (Level)context.level(), (EntitySpawnReason)EntitySpawnReason.LOAD, o -> o);
            if (entity != null) {
                if (entity.hasCustomName()) {
                    list.accept((Component)Component.literal((String)entity.getName().getString()).withStyle(ChatFormatting.GOLD));
                } else {
                    list.accept((Component)Component.translatable((String)entity.getType().toString()).withStyle(ChatFormatting.GOLD));
                }
            }
            list.accept((Component)Component.translatable((String)SupernaturalManager.getSoulgem(stack)).withStyle(ChatFormatting.DARK_PURPLE));
        }
    }

    public ItemStack getDefaultInstance() {
        ItemStack stack = super.getDefaultInstance();
        stack.set(SupernaturalData.SOULGEM, (Object)SoulgemData.EMPTY);
        return stack;
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        if (player.isCreative() && target instanceof Mob && !target.getType().is(SupernaturalTags.IMMUNITY)) {
            player.setItemInHand(hand, SupernaturalManager.setSoul(new ItemStack((ItemLike)SupernaturalItems.SOULGEM.get()), target));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

