/*
 * Decompiled with CFR 0.152.
 */
package net.salju.supernatural.entity.ai.targets;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.salju.supernatural.entity.Spooky;
import net.salju.supernatural.events.SupernaturalManager;
import net.salju.supernatural.init.SupernaturalConfig;
import net.salju.supernatural.init.SupernaturalEffects;
import net.salju.supernatural.init.SupernaturalTags;

public class SpookyAttackSelector
implements Predicate<LivingEntity> {
    private final Spooky ghost;

    public SpookyAttackSelector(Spooky source) {
        this.ghost = source;
    }

    @Override
    public boolean test(@Nullable LivingEntity target) {
        if (!target.hasEffect(SupernaturalEffects.POSSESSION) && !target.hasEffect(MobEffects.GLOWING)) {
            if (((Boolean)SupernaturalConfig.ARMOR.get()).booleanValue() && target instanceof ArmorStand) {
                return SupernaturalManager.hasArmor(target);
            }
            return target.getType().is(SupernaturalTags.SPOOKY) && !this.ghost.isTamed();
        }
        return false;
    }
}

