/*
 * Decompiled with CFR 0.152.
 */
package net.salju.supernatural.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.salju.supernatural.init.SupernaturalBlocks;
import net.salju.supernatural.init.SupernaturalData;
import net.salju.supernatural.init.SupernaturalItems;
import net.salju.supernatural.item.component.AnchorballData;

public class AnchorballItem
extends Item {
    public AnchorballItem(Item.Properties props) {
        super(props);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(stack, context, list, flag);
        AnchorballData data = (AnchorballData)stack.get(SupernaturalData.ANCHOR);
        if (data != null) {
            list.add((Component)Component.literal((String)(data.getPos().getX() + ", " + data.getPos().getY() + ", " + data.getPos().getZ())).withStyle(ChatFormatting.DARK_PURPLE));
        }
    }

    public InteractionResult useOn(UseOnContext context) {
        if (context.getLevel().getBlockState(context.getClickedPos()).is(SupernaturalBlocks.RITUAL_ALTAR) && context.getPlayer() != null && context.getPlayer().isCreative() && context.getItemInHand().is(SupernaturalItems.ANCHORBALL)) {
            context.getItemInHand().set(SupernaturalData.ANCHOR, (Object)new AnchorballData(GlobalPos.of((ResourceKey)context.getLevel().dimension(), (BlockPos)context.getClickedPos())));
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }
}

