/*
 * Decompiled with CFR 0.152.
 */
package net.salju.supernatural.item;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.salju.supernatural.events.SupernaturalManager;

public class BloodItem
extends Item {
    public BloodItem(Item.Properties props) {
        super(props);
    }

    public int getUseDuration(ItemStack stack, LivingEntity target) {
        return 40;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public SoundEvent getDrinkingSound() {
        return SoundEvents.HONEY_DRINK;
    }

    public SoundEvent getEatingSound() {
        return SoundEvents.HONEY_DRINK;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity target) {
        Player player;
        super.finishUsingItem(stack, world, target);
        if (SupernaturalManager.isVampire(target)) {
            target.heal(6.0f);
        }
        if (target instanceof Player && !(player = (Player)target).hasInfiniteMaterials()) {
            stack.shrink(1);
        }
        if (stack.isEmpty()) {
            return new ItemStack((ItemLike)Items.GLASS_BOTTLE);
        }
        if (target instanceof Player && !(player = (Player)target).hasInfiniteMaterials()) {
            ItemStack bottle = new ItemStack((ItemLike)Items.GLASS_BOTTLE);
            if (!player.getInventory().add(bottle)) {
                player.drop(bottle, false);
            }
        }
        return stack;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        if (SupernaturalManager.isVampire((LivingEntity)player)) {
            return ItemUtils.startUsingInstantly((Level)world, (Player)player, (InteractionHand)hand);
        }
        return super.use(world, player, hand);
    }
}

