/*
 * Decompiled with CFR 0.152.
 */
package net.salju.supernatural.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.salju.supernatural.init.SupernaturalConfig;
import net.salju.supernatural.init.SupernaturalData;
import net.salju.supernatural.item.component.RitualBookData;

public class RitualBookItem
extends Item {
    public RitualBookItem(Item.Properties props) {
        super(props);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(stack, context, list, flag);
        if (flag.hasShiftDown()) {
            RitualBookData data = (RitualBookData)stack.get(SupernaturalData.BOOK);
            if (data != null) {
                list.add((Component)Component.translatable((String)("desc.book.page_" + data.getPage())).withStyle(ChatFormatting.BLUE));
                list.add((Component)Component.translatable((String)("desc.book.desc_" + data.getPage())).withStyle(ChatFormatting.GRAY));
                list.add((Component)Component.empty());
                if (((Boolean)SupernaturalConfig.SACRIFICE.get()).booleanValue() && data.requiresSacrifice()) {
                    list.add((Component)Component.translatable((String)"desc.book.sacrifice").withStyle(ChatFormatting.DARK_RED));
                }
                list.add((Component)Component.translatable((String)data.getRequiredItem()).withStyle(ChatFormatting.GRAY));
                list.add((Component)Component.translatable((String)data.getSoulPower()).withStyle(ChatFormatting.DARK_PURPLE));
                list.add((Component)Component.literal((String)data.getCandles()).withStyle(ChatFormatting.GOLD));
            }
            list.add((Component)Component.empty());
            list.add((Component)Component.translatable((String)"desc.book.wheel").withStyle(ChatFormatting.GRAY));
        } else {
            list.add((Component)Component.translatable((String)"desc.book.shift").withStyle(ChatFormatting.GRAY));
        }
    }

    public ItemStack getDefaultInstance() {
        ItemStack stack = super.getDefaultInstance();
        stack.set(SupernaturalData.BOOK, (Object)RitualBookData.EMPTY);
        return stack;
    }
}

