/*
 * Decompiled with CFR 0.152.
 */
package net.salju.supernatural.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.salju.supernatural.block.RitualBlockEntity;
import net.salju.supernatural.block.Rituals;
import net.salju.supernatural.events.SupernaturalManager;
import net.salju.supernatural.init.SupernaturalBlocks;
import net.salju.supernatural.init.SupernaturalItems;

public class RitualBlock
extends BaseEntityBlock {
    public static final MapCodec<RitualBlock> CODEC = RitualBlock.simpleCodec(RitualBlock::new);

    public RitualBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    public MapCodec<RitualBlock> codec() {
        return CODEC;
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rez) {
        BlockEntity entity = world.getBlockEntity(pos);
        if (entity instanceof RitualBlockEntity) {
            ServerLevel lvl;
            Item item;
            RitualBlockEntity target = (RitualBlockEntity)entity;
            if (stack.is(ItemTags.CANDLES) && (item = stack.getItem()) instanceof BlockItem) {
                BlockItem blok = (BlockItem)item;
                List<BlockPos> list = SupernaturalManager.getCircle(pos);
                for (BlockPos poz : list) {
                    if (!world.isEmptyBlock(poz)) continue;
                    blok.place(new BlockPlaceContext(world, player, hand, stack, rez.withPosition(poz)));
                    return ItemInteractionResult.SUCCESS;
                }
            }
            if (target.isEmpty() && !stack.isEmpty()) {
                if (world instanceof ServerLevel) {
                    lvl = (ServerLevel)world;
                    target.setItem(0, stack);
                    lvl.playSound(null, target.getBlockPos(), SoundEvents.ITEM_FRAME_ADD_ITEM, SoundSource.BLOCKS, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
                    if (!player.isCreative()) {
                        stack.shrink(1);
                    }
                }
                return ItemInteractionResult.SUCCESS;
            }
            if (!target.isEmpty()) {
                if (world instanceof ServerLevel) {
                    lvl = (ServerLevel)world;
                    if (stack.is((Item)SupernaturalItems.SOULGEM.get())) {
                        Rituals.doRitual(target.getItem(0), stack, lvl, player, pos);
                    } else {
                        target.dropItem(0);
                    }
                }
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.FAIL;
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean bool) {
        if (!state.is(newState.getBlock())) {
            RitualBlockEntity target;
            BlockEntity entity = world.getBlockEntity(pos);
            if (entity instanceof RitualBlockEntity && !(target = (RitualBlockEntity)entity).isEmpty()) {
                target.dropItem(0);
            }
            super.onRemove(state, world, pos, newState, bool);
        }
    }

    public boolean triggerEvent(BlockState state, Level world, BlockPos pos, int i, int e) {
        return world.getBlockEntity(pos) == null ? super.triggerEvent(state, world, pos, i, e) : world.getBlockEntity(pos).triggerEvent(i, e);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        RitualBlockEntity target;
        BlockEntity entity = world.getBlockEntity(pos);
        if (entity instanceof RitualBlockEntity && !(target = (RitualBlockEntity)entity).isEmpty()) {
            return AbstractContainerMenu.getRedstoneSignalFromContainer((Container)target);
        }
        return 0;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new RitualBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return RitualBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)SupernaturalBlocks.RITUAL.get()), RitualBlockEntity::tick);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.or((VoxelShape)RitualBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0), (VoxelShape[])new VoxelShape[]{RitualBlock.box((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)4.0), RitualBlock.box((double)12.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0), RitualBlock.box((double)0.0, (double)0.0, (double)12.0, (double)4.0, (double)16.0, (double)16.0), RitualBlock.box((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0)});
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }
}

