/*
 * Decompiled with CFR 0.152.
 */
package net.salju.supernatural.entity.ai.spells;

import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.salju.supernatural.entity.AbstractVampireEntity;
import net.salju.supernatural.entity.Spellcaster;

public class AbstractSpellcasterGoal
extends Goal {
    public final Mob user;

    public AbstractSpellcasterGoal(Mob target) {
        this.user = target;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        Mob mob = this.user;
        if (mob instanceof AbstractVampireEntity) {
            AbstractVampireEntity target = (AbstractVampireEntity)mob;
            return target.isCastingSpell();
        }
        mob = this.user;
        if (mob instanceof Spellcaster) {
            Spellcaster target = (Spellcaster)mob;
            return target.isCastingSpell();
        }
        return false;
    }

    public void stop() {
        super.stop();
        Mob mob = this.user;
        if (mob instanceof AbstractVampireEntity) {
            AbstractVampireEntity target = (AbstractVampireEntity)mob;
            target.setIsCastingSpell(0);
        } else {
            mob = this.user;
            if (mob instanceof Spellcaster) {
                Spellcaster target = (Spellcaster)mob;
                target.setSpellTick(0);
            }
        }
    }

    public void tick() {
        if (this.user.getTarget() != null) {
            this.user.getLookControl().setLookAt((Entity)this.user.getTarget(), (float)this.user.getMaxHeadYRot(), (float)this.user.getMaxHeadXRot());
        }
    }
}

