/*
 * Decompiled with CFR 0.152.
 */
package net.salju.supernatural.entity.ai.spells.spooky;

import java.util.Optional;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.salju.supernatural.entity.PossessedArmor;
import net.salju.supernatural.entity.Spooky;
import net.salju.supernatural.entity.ai.spells.AbstractSpellGoal;
import net.salju.supernatural.events.SupernaturalManager;
import net.salju.supernatural.init.SupernaturalEffects;
import net.salju.supernatural.init.SupernaturalMobs;
import net.salju.supernatural.init.SupernaturalSounds;

public class SpookyPossessionSpellGoal
extends AbstractSpellGoal {
    public SpookyPossessionSpellGoal(Spooky target) {
        super((Mob)target);
    }

    @Override
    protected void performSpellCasting() {
        Mob mob;
        if (this.user.getTarget() != null && this.user.getTarget().isAlive() && (mob = this.user) instanceof Spooky) {
            Spooky ghost = (Spooky)mob;
            LivingEntity livingEntity = ghost.getTarget();
            if (livingEntity instanceof ArmorStand) {
                ArmorStand target = (ArmorStand)livingEntity;
                if (SupernaturalManager.hasArmor((LivingEntity)target)) {
                    ghost.playSound((SoundEvent)SupernaturalSounds.SPOOK_POOF.get(), 1.0f, 1.0f);
                    Level level = target.level();
                    if (level instanceof ServerLevel) {
                        lvl = (ServerLevel)level;
                        PossessedArmor armor = (PossessedArmor)((Object)SupernaturalManager.convertArmor(target, (EntityType)SupernaturalMobs.POSSESSED_ARMOR.get(), true));
                        if (ghost.getOwner() != null) {
                            ItemStack sword = new ItemStack((ItemLike)Items.IRON_SWORD);
                            EnchantmentHelper.enchantItem((RandomSource)ghost.getRandom(), (ItemStack)sword, (int)32, (RegistryAccess)lvl.registryAccess(), Optional.empty());
                            armor.setOwner(ghost.getOwner());
                            armor.setItemSlot(EquipmentSlot.MAINHAND, sword);
                        }
                        double r = ghost.getRandom().nextGaussian() * 0.02;
                        lvl.sendParticles((ParticleOptions)ParticleTypes.POOF, ghost.getRandomX(1.0), ghost.getRandomY(), ghost.getRandomZ(1.0), 10, r, r, r, 0.25);
                        ghost.discard();
                    }
                }
            } else {
                lvl = ghost.getTarget();
                if (lvl instanceof LivingEntity) {
                    LivingEntity target = lvl;
                    target.addEffect(new MobEffectInstance(SupernaturalEffects.POSSESSION, 6000, 0));
                    target.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 32, 0, false, false));
                    Level armor = ghost.level();
                    if (armor instanceof ServerLevel) {
                        lvl = (ServerLevel)armor;
                        ghost.playSound((SoundEvent)SupernaturalSounds.SPOOK_POOF.get(), 1.0f, 1.0f);
                        ghost.discard();
                        double r = ghost.getRandom().nextGaussian() * 0.02;
                        lvl.sendParticles((ParticleOptions)ParticleTypes.POOF, ghost.getRandomX(1.0), ghost.getRandomY(), ghost.getRandomZ(1.0), 10, r, r, r, 0.25);
                    }
                }
            }
        }
    }

    @Override
    protected int getCastingTime() {
        return 30;
    }

    @Override
    protected int getCastingInterval() {
        return 120;
    }

    @Override
    protected int getSpell() {
        return 0;
    }

    @Override
    protected SoundEvent getSpellPrepareSound() {
        return SoundEvents.ILLUSIONER_PREPARE_BLINDNESS;
    }
}

