/*
 * Decompiled with CFR 0.152.
 */
package net.salju.supernatural.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.salju.kobolds.client.model.KoboldArmorModel;

public class GothicKoboldArmorModel<T extends LivingEntity>
extends HumanoidModel<T> {
    private final EquipmentSlot slot;
    private final ModelPart feather;
    private final ItemStack stack;

    public GothicKoboldArmorModel(ModelPart root, ItemStack stack, EquipmentSlot slot) {
        super(root);
        this.stack = stack;
        this.slot = slot;
        this.feather = root.getChild("feather");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = KoboldArmorModel.createBaseArmor((CubeDeformation)new CubeDeformation(0.0f), (boolean)true);
        PartDefinition root = mesh.getRoot();
        root.getChild("head").addOrReplaceChild("front", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -7.5f, -7.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(-0.25f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.48f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("feather", CubeListBuilder.create().texOffs(25, -7).addBox(0.0f, -13.2f, 0.65f, 0.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)32);
    }

    public void renderToBuffer(PoseStack pose, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        if (this.slot == EquipmentSlot.HEAD) {
            pose.pushPose();
            this.feather.copyFrom(this.head);
            if (this.young) {
                pose.scale(0.75f, 0.75f, 0.75f);
                this.head.setPos(0.0f, 15.0f, 0.0f);
            }
            this.head.render(pose, buffer, packedLight, packedOverlay);
            this.feather.render(pose, buffer, packedLight, packedOverlay, DyedItemColor.getOrDefault((ItemStack)this.stack, (int)color));
            pose.popPose();
        }
    }
}

