/*
 * Decompiled with CFR 0.152.
 */
package net.salju.supernatural.entity.ai.spells;

import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.salju.supernatural.entity.AbstractSpellcasterEntity;
import net.salju.supernatural.entity.AbstractVampireEntity;

public abstract class AbstractSpellGoal
extends Goal {
    public final Mob user;
    protected int attackWarmupDelay;
    protected int nextAttackTickCount;

    public AbstractSpellGoal(Mob target) {
        this.user = target;
    }

    public boolean canUse() {
        if (this.user.getTarget() != null && this.user.getTarget().isAlive()) {
            Mob mob = this.user;
            if (mob instanceof AbstractVampireEntity) {
                AbstractVampireEntity target = (AbstractVampireEntity)mob;
                if (target.isCastingSpell()) {
                    return false;
                }
                return this.user.tickCount >= this.nextAttackTickCount;
            }
            mob = this.user;
            if (mob instanceof AbstractSpellcasterEntity) {
                AbstractSpellcasterEntity target = (AbstractSpellcasterEntity)mob;
                if (target.isCastingSpell()) {
                    return false;
                }
                return this.user.tickCount >= this.nextAttackTickCount;
            }
        }
        return false;
    }

    public boolean canContinueToUse() {
        LivingEntity target = this.user.getTarget();
        return target != null && target.isAlive() && this.attackWarmupDelay > 0;
    }

    public void start() {
        this.attackWarmupDelay = this.adjustedTickDelay(this.getCastWarmupTime());
        this.nextAttackTickCount = this.user.tickCount + this.getCastingInterval();
        Mob mob = this.user;
        if (mob instanceof AbstractVampireEntity) {
            AbstractVampireEntity target = (AbstractVampireEntity)mob;
            target.setSpellCastingTime(this.getCastingTime());
            target.setIsCastingSpell(this.getSpell());
        } else {
            mob = this.user;
            if (mob instanceof AbstractSpellcasterEntity) {
                AbstractSpellcasterEntity target = (AbstractSpellcasterEntity)mob;
                target.setSpellTick(this.getCastingTime());
            }
        }
        if (this.getSpellPrepareSound() != null) {
            this.user.playSound(this.getSpellPrepareSound(), 1.0f, 1.0f);
        }
    }

    public void tick() {
        --this.attackWarmupDelay;
        if (this.attackWarmupDelay == 0) {
            this.performSpellCasting();
            Mob mob = this.user;
            if (mob instanceof AbstractVampireEntity) {
                AbstractVampireEntity target = (AbstractVampireEntity)mob;
                this.user.playSound(target.getCastingSoundEvent(), 1.0f, 1.0f);
            } else {
                mob = this.user;
                if (mob instanceof AbstractSpellcasterEntity) {
                    AbstractSpellcasterEntity target = (AbstractSpellcasterEntity)mob;
                    this.user.playSound(target.getCastingSoundEvent(), 1.0f, 1.0f);
                }
            }
        }
    }

    protected abstract void performSpellCasting();

    protected int getCastWarmupTime() {
        return 20;
    }

    protected abstract int getCastingTime();

    protected abstract int getCastingInterval();

    @Nullable
    protected abstract SoundEvent getSpellPrepareSound();

    protected abstract int getSpell();
}

