/*
 * Decompiled with CFR 0.152.
 */
package net.salju.supernatural.block;

import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.Spawner;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.salju.supernatural.Supernatural;
import net.salju.supernatural.block.RitualBlockEntity;
import net.salju.supernatural.entity.Angel;
import net.salju.supernatural.events.SupernaturalManager;
import net.salju.supernatural.init.SupernaturalBlocks;
import net.salju.supernatural.init.SupernaturalConfig;
import net.salju.supernatural.init.SupernaturalDamageTypes;
import net.salju.supernatural.init.SupernaturalData;
import net.salju.supernatural.init.SupernaturalItems;
import net.salju.supernatural.init.SupernaturalTags;
import net.salju.supernatural.item.RitualCompassItem;
import net.salju.supernatural.item.component.AnchorballData;

public class Rituals {
    public static void doRitual(ItemStack stack, ItemStack offer, ServerLevel lvl, Player player, BlockPos pos) {
        BlockEntity blockEntity = lvl.getBlockEntity(pos);
        if (blockEntity instanceof RitualBlockEntity) {
            RitualBlockEntity target = (RitualBlockEntity)blockEntity;
            if (SupernaturalManager.canRitualsWork(lvl, pos, target)) {
                int i = SupernaturalManager.getPower(lvl, pos);
                int e = SupernaturalManager.getSoulLevel(SupernaturalManager.getSoulgem(offer));
                if (stack.is((Item)SupernaturalItems.CONTRACT.get()) && i == 20 && e >= 5 && !SupernaturalManager.isVampire((LivingEntity)player)) {
                    Goat goat = Rituals.getGoat(lvl, new AABB(pos).inflate(((Double)SupernaturalConfig.ALTARRANGE.get()).doubleValue()));
                    if (goat != null || !((Boolean)SupernaturalConfig.SACRIFICE.get()).booleanValue()) {
                        Rituals.defaultResult(target, offer, lvl, player, pos);
                        player.hurt(SupernaturalDamageTypes.causeRitualDamage(player.level().registryAccess(), (LivingEntity)player), 0.25f);
                        if (player.isAlive()) {
                            player.setHealth(1.0f);
                        }
                        SupernaturalManager.setVampire(player, true);
                        if (((Boolean)SupernaturalConfig.SACRIFICE.get()).booleanValue()) {
                            goat.hurt(SupernaturalDamageTypes.causeRitualDamage(goat.level().registryAccess(), (LivingEntity)player), Float.MAX_VALUE);
                        }
                    }
                } else if (stack.is((Item)SupernaturalItems.GRAVE_SOIL.get()) && i == 28 && e >= 0) {
                    Rituals.defaultResult(target, offer, lvl, player, pos);
                    if (((Boolean)SupernaturalConfig.SACRIFICE.get()).booleanValue()) {
                        Mob sacrifice = Rituals.getSacrifice(lvl, offer, new AABB(pos).inflate(((Double)SupernaturalConfig.ALTARRANGE.get()).doubleValue()));
                        (sacrifice != null ? sacrifice : player).hurt(SupernaturalDamageTypes.causeRitualDamage(player.level().registryAccess(), (LivingEntity)player), Float.MAX_VALUE);
                    }
                    Rituals.summonMob(lvl, pos.above(), offer);
                    lvl.playSound(null, pos, (SoundEvent)SoundEvents.SOUL_ESCAPE.value(), SoundSource.BLOCKS, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
                } else if (stack.is((Item)SupernaturalItems.VAMPIRE_DUST.get())) {
                    if (i == 8 && e >= 1) {
                        Rituals.defaultResult(target, offer, lvl, player, pos);
                        BlockPos top = BlockPos.containing((double)(pos.getX() + 3), (double)(pos.getY() - 1), (double)(pos.getZ() + 3));
                        BlockPos bot = BlockPos.containing((double)(pos.getX() - 3), (double)(pos.getY() - 1), (double)(pos.getZ() - 3));
                        for (BlockPos poz : BlockPos.betweenClosed((BlockPos)top, (BlockPos)bot)) {
                            if (!lvl.getBlockState(poz).is(SupernaturalTags.SOIL)) continue;
                            lvl.setBlock(poz, ((Block)SupernaturalBlocks.GRAVE_SOIL.get()).defaultBlockState(), 3);
                        }
                    } else if (i == 16 && e >= 4) {
                        Rituals.defaultResult(target, offer, lvl, player, pos);
                        for (Angel statue : lvl.getEntitiesOfClass(Angel.class, new AABB(pos).inflate(((Double)SupernaturalConfig.ALTARRANGE.get()).doubleValue()))) {
                            if (statue.isCursed()) continue;
                            statue.getEntityData().set(Angel.CURSED, (Object)true);
                            lvl.sendParticles((ParticleOptions)ParticleTypes.SOUL, statue.getX() + 0.5, statue.getY() + 0.5, statue.getZ() + 0.5, 8, 0.25, 0.35, 0.25, 0.0);
                        }
                    }
                } else if (stack.is(SupernaturalTags.INGOTS) && i == 12 && e >= 2) {
                    Rituals.defaultResult(target, offer, lvl, player, pos);
                    target.setItem(0, new ItemStack((ItemLike)(stack.is(Items.IRON_INGOT) ? Items.GOLD_INGOT : Items.IRON_INGOT)));
                } else if (stack.is(SupernaturalTags.HELMS) && i == 16 && e >= 3) {
                    ItemStack copy = stack.transmuteCopy((ItemLike)Rituals.getHelmet(stack.getItem()));
                    Rituals.defaultResult(target, offer, lvl, player, pos);
                    target.setItem(0, copy);
                } else if (stack.is(SupernaturalTags.MONEY) && i == 16 && e >= 2) {
                    ItemStack copy = stack.copy();
                    Rituals.defaultResult(target, offer, lvl, player, pos);
                    target.setGreedy(true);
                    for (int r = 0; r < 11; ++r) {
                        int t = 10 * r;
                        Supernatural.queueServerWork(t, () -> {
                            if (target.stillValid(player)) {
                                if (t >= 100) {
                                    if (target.getItem(0).is(Items.NETHER_STAR)) {
                                        for (int p = 0; p < 10; ++p) {
                                            Supernatural.queueServerWork(10 * p, () -> {
                                                if (target.stillValid(player)) {
                                                    target.cloneItem(copy.copy());
                                                }
                                            });
                                        }
                                    }
                                    target.clearContent();
                                    target.setGreedy(false);
                                } else {
                                    target.setItem(0, new ItemStack((ItemLike)Rituals.getGreedyItem(Mth.nextInt((RandomSource)player.getRandom(), (int)0, (int)12))));
                                }
                            }
                        });
                    }
                } else if (stack.is((Item)SupernaturalItems.ANCHORBALL.get()) && i == 12 && e >= 3) {
                    ItemStack copy = stack.copy();
                    AnchorballData data = (AnchorballData)copy.get((DataComponentType)SupernaturalData.ANCHOR.get());
                    Rituals.defaultResult(target, offer, lvl, player, pos);
                    if (data != null && lvl.isInWorldBounds(data.getPos()) && lvl.getPoiManager().existsAtPosition(SupernaturalBlocks.RITUAL_POI.getKey(), data.getPos())) {
                        target.setItem(0, copy);
                        ServerLevel loc = lvl.getServer().getLevel(data.target().dimension());
                        double x = (double)data.getPos().getX() + 0.5;
                        double y = (double)data.getPos().getY() + 0.7;
                        double z = (double)data.getPos().getZ() + 0.5;
                        if (loc != null && player instanceof ServerPlayer) {
                            ServerPlayer ply = (ServerPlayer)player;
                            lvl.playSound(null, pos, SoundEvents.ENDERMAN_TELEPORT, SoundSource.BLOCKS, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
                            lvl.sendParticles((ParticleOptions)ParticleTypes.PORTAL, (double)pos.getX(), (double)pos.getY() + 0.75, (double)pos.getZ(), 12, 0.5, 0.5, 0.5, 0.65);
                            ply.teleportTo(loc, x, y, z, ply.getYRot(), ply.getXRot());
                            loc.playSound(null, data.getPos(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.BLOCKS, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
                            loc.sendParticles((ParticleOptions)ParticleTypes.PORTAL, x, y, z, 12, 0.5, 0.5, 0.5, 0.65);
                        }
                    }
                } else if (stack.is(Items.WRITABLE_BOOK) && i == 12 && e >= 3) {
                    Rituals.defaultResult(target, offer, lvl, player, pos);
                    target.setItem(0, new ItemStack((ItemLike)SupernaturalItems.RITUAL_BOOK.get()));
                } else if (stack.is(Items.TOTEM_OF_UNDYING) && i == 28 && e >= 0) {
                    Entity entity = EntityType.loadEntityRecursive((CompoundTag)SupernaturalManager.getSoulTag(offer), (Level)lvl, o -> o);
                    BlockEntity blockEntity2 = lvl.getBlockEntity(pos.above());
                    if (blockEntity2 instanceof Spawner) {
                        Spawner blok = (Spawner)blockEntity2;
                        if (entity != null && entity.getType().is(SupernaturalTags.SPAWNER)) {
                            blok.setEntityId(entity.getType(), lvl.getRandom());
                            Rituals.defaultResult(target, offer, lvl, player, pos);
                            lvl.sendBlockUpdated(pos.above(), lvl.getBlockState(pos.above()), lvl.getBlockState(pos.above()), 3);
                            lvl.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos.above());
                        }
                    }
                } else if (stack.is(Items.COMPASS)) {
                    if (i == 12 && e >= 3) {
                        Rituals.defaultResult(target, offer, lvl, player, pos);
                        target.setItem(0, RitualCompassItem.getRitualCompass(pos, lvl, 0));
                    } else if (i == 20 && e >= 4) {
                        Rituals.defaultResult(target, offer, lvl, player, pos);
                        target.setItem(0, RitualCompassItem.getRitualCompass(pos, lvl, 1));
                    } else if (i == 28 && e >= 5) {
                        Rituals.defaultResult(target, offer, lvl, player, pos);
                        target.setItem(0, RitualCompassItem.getRitualCompass(pos, lvl, 2));
                    }
                } else if (stack.is(Items.ENDER_PEARL) && i == 16 && e >= 4) {
                    ItemStack copy = new ItemStack((ItemLike)SupernaturalItems.ANCHORBALL.get());
                    Rituals.defaultResult(target, offer, lvl, player, pos);
                    copy.set(SupernaturalData.ANCHOR, (Object)new AnchorballData(GlobalPos.of((ResourceKey)lvl.dimension(), (BlockPos)pos)));
                    target.setItem(0, copy);
                } else if (stack.isEnchantable() && (player.experienceLevel >= 30 || player.isCreative())) {
                    ItemStack copy = stack.copy();
                    Rituals.defaultResult(target, offer, lvl, player, pos);
                    int c = e * (Integer)SupernaturalConfig.SOULPOWER.get() + i;
                    target.setItem(0, EnchantmentHelper.enchantItem((RandomSource)lvl.getRandom(), (ItemStack)copy, (int)c, (RegistryAccess)lvl.registryAccess(), Optional.empty()));
                    lvl.playSound(null, pos, SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.BLOCKS, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
                    if (!player.isCreative()) {
                        player.giveExperiencePoints(c * -2);
                    }
                } else {
                    target.dropItem(0);
                }
            } else {
                target.dropItem(0);
            }
        }
    }

    private static void defaultResult(RitualBlockEntity target, ItemStack stack, ServerLevel lvl, Player player, BlockPos pos) {
        target.clearContent();
        lvl.playSound(null, pos, (SoundEvent)SoundEvents.SOUL_ESCAPE.value(), SoundSource.BLOCKS, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
        lvl.sendParticles((ParticleOptions)ParticleTypes.SOUL, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 21, 3.0, 1.0, 3.0, 0.0);
        if (!player.isCreative()) {
            stack.shrink(1);
        }
    }

    private static void summonMob(ServerLevel lvl, BlockPos pos, ItemStack stack) {
        Entity entity = EntityType.loadEntityRecursive((CompoundTag)SupernaturalManager.getSoulTag(stack), (Level)lvl, o -> o);
        if (entity != null) {
            LightningBolt bolt;
            Villager bob;
            ZombieVillager zomby;
            entity.moveTo(Vec3.atBottomCenterOf((Vec3i)pos));
            if (entity instanceof Villager && (zomby = (ZombieVillager)(bob = (Villager)entity).convertTo(EntityType.ZOMBIE_VILLAGER, false)) != null) {
                zomby.setVillagerData(bob.getVillagerData());
                zomby.setGossips((Tag)bob.getGossips().store((DynamicOps)NbtOps.INSTANCE));
                zomby.setTradeOffers(bob.getOffers());
                zomby.setVillagerXp(bob.getVillagerXp());
            }
            if (lvl.canSeeSky(pos) && (bolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create((Level)lvl)) != null) {
                bolt.moveTo(Vec3.atBottomCenterOf((Vec3i)pos));
                bolt.setVisualOnly(true);
                lvl.addFreshEntity((Entity)bolt);
            }
            lvl.addFreshEntity(entity);
        }
    }

    private static Item getHelmet(Item target) {
        HashMap<Item, Item> map = new HashMap<Item, Item>();
        map.put(Items.IRON_HELMET, (Item)SupernaturalItems.GOTHIC_IRON_HELMET.get());
        map.put(Items.GOLDEN_HELMET, (Item)SupernaturalItems.GOTHIC_GOLDEN_HELMET.get());
        map.put(Items.DIAMOND_HELMET, (Item)SupernaturalItems.GOTHIC_DIAMOND_HELMET.get());
        map.put(Items.NETHERITE_HELMET, (Item)SupernaturalItems.GOTHIC_NETHERITE_HELMET.get());
        return map.getOrDefault(target, Items.AIR);
    }

    private static Item getGreedyItem(int i) {
        HashMap<Integer, Item> map = new HashMap<Integer, Item>();
        map.put(0, Items.NETHER_STAR);
        map.put(1, Items.ROTTEN_FLESH);
        map.put(2, Items.BONE);
        map.put(3, Items.SPIDER_EYE);
        map.put(4, Items.FERMENTED_SPIDER_EYE);
        map.put(5, Items.SLIME_BALL);
        map.put(6, Items.POISONOUS_POTATO);
        map.put(7, Items.ROTTEN_FLESH);
        map.put(8, Items.BONE);
        map.put(9, Items.SPIDER_EYE);
        map.put(10, Items.FERMENTED_SPIDER_EYE);
        map.put(11, Items.SLIME_BALL);
        map.put(12, Items.POISONOUS_POTATO);
        return map.getOrDefault(i, Items.AIR);
    }

    @Nullable
    private static Goat getGoat(ServerLevel lvl, AABB box) {
        Iterator iterator = lvl.getEntitiesOfClass(Goat.class, box).iterator();
        if (iterator.hasNext()) {
            Goat target = (Goat)iterator.next();
            return target;
        }
        return null;
    }

    @Nullable
    private static Mob getSacrifice(ServerLevel lvl, ItemStack stack, AABB box) {
        for (Mob target : lvl.getEntitiesOfClass(Mob.class, box)) {
            if (SupernaturalManager.getSoulLevel(SupernaturalManager.getSoulLevel((LivingEntity)target)) < SupernaturalManager.getSoulLevel(SupernaturalManager.getSoulgem(stack)) || target.getType().is(SupernaturalTags.IMMUNITY)) continue;
            return target;
        }
        return null;
    }
}

