/*
 * Decompiled with CFR 0.152.
 */
package net.salju.supernatural.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.salju.supernatural.entity.Angel;

public class AngelModel<T extends Angel>
extends EntityModel<T> {
    private final ModelPart head;
    private final ModelPart hat;
    private final ModelPart body;
    private final ModelPart right_arm;
    private final ModelPart left_arm;
    private final ModelPart right_wing;
    private final ModelPart left_wing;

    public AngelModel(ModelPart root) {
        this.body = root.getChild("body");
        this.head = this.body.getChild("head");
        this.hat = this.head.getChild("hat");
        this.right_arm = this.body.getChild("right_arm");
        this.left_arm = this.body.getChild("left_arm");
        this.right_wing = this.body.getChild("right_wing");
        this.left_wing = this.body.getChild("left_wing");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(14, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(12, 30).addBox(-4.5f, 10.0f, -2.5f, 9.0f, 9.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(11, 44).addBox(-5.0f, 19.0f, -3.0f, 10.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.25f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(0, 16).addBox(-3.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)2.0f, (float)0.0f));
        body.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(0.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)4.0f, (float)2.0f, (float)0.0f));
        body.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(42, 5).mirror().addBox(2.0f, -11.0f, -8.5f, 0.0f, 19.0f, 11.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-2.0f, (float)4.0f, (float)5.0f));
        body.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(42, 5).addBox(-2.0f, -11.0f, -8.5f, 0.0f, 19.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)4.0f, (float)5.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
    }

    public void setupAnim(T angel, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        this.head.xRot = 0.0f;
        this.head.yRot = 0.0f;
        this.head.zRot = 0.0f;
        this.hat.xRot = 0.0f;
        this.hat.yRot = 0.0f;
        this.hat.zRot = 0.0f;
        this.body.xRot = 0.0f;
        this.body.yRot = headYaw * ((float)Math.PI / 180);
        this.body.zRot = 0.0f;
        this.right_wing.xRot = 0.0f;
        this.right_wing.yRot = 2.7053f;
        this.right_wing.zRot = 0.0f;
        this.left_wing.xRot = 0.0f;
        this.left_wing.yRot = -2.7053f;
        this.left_wing.zRot = 0.0f;
        this.right_arm.xRot = 0.0f;
        this.right_arm.yRot = 0.0f;
        this.right_arm.zRot = 0.0f;
        this.left_arm.xRot = 0.0f;
        this.left_arm.yRot = 0.0f;
        this.left_arm.zRot = 0.0f;
        if (((Angel)((Object)angel)).getAngelPose() == 0) {
            this.right_arm.xRot = -1.5708f;
            this.left_arm.xRot = -1.5708f;
        } else if (((Angel)((Object)angel)).getAngelPose() == 2) {
            this.right_arm.xRot = -0.7854f;
            this.right_arm.yRot = -0.5236f;
            this.left_arm.xRot = -0.7854f;
            this.left_arm.yRot = 0.5236f;
        } else if (((Angel)((Object)angel)).getAngelPose() == 3) {
            this.head.xRot = 0.2618f;
            this.hat.xRot = 0.2618f;
            this.right_arm.xRot = -1.9199f;
            this.right_arm.yRot = -0.4363f;
            this.left_arm.xRot = -1.9199f;
            this.left_arm.yRot = 0.4363f;
        } else if (((Angel)((Object)angel)).getAngelPose() == 4) {
            this.right_arm.xRot = -1.5708f;
        } else if (((Angel)((Object)angel)).getAngelPose() == 5) {
            this.head.xRot = -0.2618f;
            this.hat.xRot = -0.2618f;
            this.right_arm.xRot = -3.0543f;
            this.right_arm.zRot = -0.0873f;
            this.left_arm.xRot = -3.0543f;
            this.left_arm.zRot = 0.0873f;
        } else if (((Angel)((Object)angel)).getAngelPose() == 6) {
            this.right_arm.xRot = -0.0436f;
            this.right_arm.zRot = 1.5708f;
            this.left_arm.xRot = -0.0436f;
            this.left_arm.zRot = -1.5708f;
        } else if (((Angel)((Object)angel)).getAngelPose() == 7) {
            this.head.xRot = 0.2618f;
            this.head.yRot = 0.7854f;
            this.hat.xRot = 0.2618f;
            this.hat.yRot = 0.7854f;
            this.right_arm.xRot = -1.9199f;
            this.right_arm.yRot = 0.7854f;
            this.left_arm.xRot = -1.9199f;
            this.left_arm.yRot = 0.8727f;
        }
    }

    public void renderToBuffer(PoseStack pose, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.body.render(pose, buffer, packedLight, packedOverlay);
    }
}

