/*
 * Decompiled with CFR 0.152.
 */
package net.salju.supernatural.client.model;

import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.salju.supernatural.entity.PossessedArmor;

public class PossessedModel<T extends PossessedArmor>
extends HumanoidModel<T> {
    public PossessedModel(ModelPart root) {
        super(root);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
    }

    public void setupAnim(T ghost, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        this.rightArm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f - 0.0025f;
        this.leftArm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f - 0.0025f;
        this.rightArm.yRot = 0.0f;
        this.rightArm.zRot = 0.0f;
        this.leftArm.yRot = 0.0f;
        this.leftArm.zRot = 0.0f;
        this.rightLeg.yRot = 0.0f;
        this.leftLeg.yRot = 0.0f;
        this.body.xRot = 0.0f;
        this.body.yRot = 0.0f;
        this.body.zRot = 0.0f;
        this.rightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount + 0.0025f;
        this.leftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount - 0.0025f;
        this.head.yRot = headYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.hat.yRot = headYaw * ((float)Math.PI / 180);
        this.hat.xRot = headPitch * ((float)Math.PI / 180);
        if (this.riding) {
            this.rightLeg.xRot = -1.5708f;
            this.leftLeg.xRot = -1.5708f;
            this.rightLeg.yRot = 0.2618f;
            this.leftLeg.yRot = -0.2618f;
        }
        if (ghost.hasItemInSlot(EquipmentSlot.MAINHAND) && ghost.isAggressive()) {
            if (ghost.isLeftHanded()) {
                this.leftArm.xRot = -2.0944f;
                this.leftArm.yRot = -0.1745f;
            } else {
                this.rightArm.xRot = -2.0944f;
                this.rightArm.yRot = 0.1745f;
            }
        }
        if (this.attackTime > 0.0f) {
            if (ghost.isAggressive()) {
                if (ghost.isLeftHanded()) {
                    float progress = this.attackTime;
                    progress = 1.0f - this.attackTime;
                    progress *= progress;
                    progress *= progress;
                    progress = 1.0f - progress;
                    float f2 = Mth.sin((float)(progress * (float)Math.PI));
                    this.leftArm.xRot = (float)((double)this.leftArm.xRot - ((double)f2 / 1.2 - 1.0));
                } else {
                    float progress = this.attackTime;
                    progress = 1.0f - this.attackTime;
                    progress *= progress;
                    progress *= progress;
                    progress = 1.0f - progress;
                    float f2 = Mth.sin((float)(progress * (float)Math.PI));
                    this.rightArm.xRot = (float)((double)this.rightArm.xRot - ((double)f2 / 1.2 - 1.0));
                }
            } else if (ghost.hasItemInSlot(EquipmentSlot.OFFHAND)) {
                float progress = this.attackTime;
                this.body.yRot = Mth.sin((float)(Mth.sqrt((float)progress) * ((float)Math.PI * 2))) * 0.2f;
                this.rightArm.yRot += this.body.yRot;
                this.leftArm.yRot += this.body.yRot;
                this.leftArm.xRot += this.body.yRot;
                progress = 1.0f - this.attackTime;
                progress *= progress;
                progress *= progress;
                progress = 1.0f - progress;
                float f2 = Mth.sin((float)(progress * (float)Math.PI));
                float f3 = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -(this.head.xRot - 0.7f) * 0.75f;
                this.rightArm.xRot = (float)((double)this.rightArm.xRot - ((double)f2 * 1.2 + (double)f3));
                this.rightArm.yRot += this.body.yRot * 2.0f;
                this.rightArm.zRot += Mth.sin((float)(this.attackTime * (float)Math.PI)) * -0.4f;
            }
        }
    }
}

