/*
 * Decompiled with CFR 0.152.
 */
package net.salju.supernatural.entity.ai.spells;

import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.salju.supernatural.entity.AbstractVampireEntity;

public abstract class AbstractSupernaturalSpellGoal
extends Goal {
    private final Monster user;
    protected int attackWarmupDelay;
    protected int nextAttackTickCount;

    public AbstractSupernaturalSpellGoal(Monster source) {
        this.user = source;
    }

    public boolean canUse() {
        Monster monster;
        LivingEntity target = this.user.getTarget();
        if (target != null && target.isAlive() && (monster = this.user) instanceof AbstractVampireEntity) {
            AbstractVampireEntity vampire = (AbstractVampireEntity)monster;
            if (vampire.isCastingSpell()) {
                return false;
            }
            return vampire.tickCount >= this.nextAttackTickCount;
        }
        return false;
    }

    public boolean canContinueToUse() {
        LivingEntity target = this.user.getTarget();
        return target != null && target.isAlive() && this.attackWarmupDelay > 0;
    }

    public void start() {
        this.attackWarmupDelay = this.adjustedTickDelay(this.getCastWarmupTime());
        this.nextAttackTickCount = this.user.tickCount + this.getCastingInterval();
        Monster monster = this.user;
        if (monster instanceof AbstractVampireEntity) {
            AbstractVampireEntity vampire = (AbstractVampireEntity)monster;
            vampire.setSpellCastingTime(this.getCastingTime());
            vampire.setIsCastingSpell(this.getSpell());
        }
        if (this.getSpellPrepareSound() != null) {
            this.user.playSound(this.getSpellPrepareSound(), 1.0f, 1.0f);
        }
    }

    public void tick() {
        --this.attackWarmupDelay;
        if (this.attackWarmupDelay == 0) {
            this.performSpellCasting();
            Monster monster = this.user;
            if (monster instanceof AbstractVampireEntity) {
                AbstractVampireEntity vampire = (AbstractVampireEntity)monster;
                vampire.playSound(vampire.getCastingSoundEvent(), 1.0f, 1.0f);
            }
        }
    }

    protected abstract void performSpellCasting();

    protected int getCastWarmupTime() {
        return 20;
    }

    protected abstract int getCastingTime();

    protected abstract int getCastingInterval();

    @Nullable
    protected abstract SoundEvent getSpellPrepareSound();

    protected abstract int getSpell();
}

