/*
 * Decompiled with CFR 0.152.
 */
package net.salju.supernatural.entity.ai.spells;

import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.salju.supernatural.entity.AbstractVampireEntity;

public class SupernaturalSpellcasterGoal
extends Goal {
    private final Monster target;

    public SupernaturalSpellcasterGoal(Monster source) {
        this.target = source;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        Monster monster = this.target;
        if (monster instanceof AbstractVampireEntity) {
            AbstractVampireEntity vampire = (AbstractVampireEntity)monster;
            return vampire.isCastingSpell();
        }
        return false;
    }

    public void stop() {
        super.stop();
        Monster monster = this.target;
        if (monster instanceof AbstractVampireEntity) {
            AbstractVampireEntity vampire = (AbstractVampireEntity)monster;
            vampire.setIsCastingSpell(0);
        }
    }

    public void tick() {
        if (this.target.getTarget() != null) {
            this.target.getLookControl().setLookAt((Entity)this.target.getTarget(), (float)this.target.getMaxHeadYRot(), (float)this.target.getMaxHeadXRot());
        }
    }
}

