/*
 * Decompiled with CFR 0.152.
 */
package net.salju.supernatural.events;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.living.LivingExperienceDropEvent;
import net.neoforged.neoforge.event.entity.living.LivingHealEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.salju.supernatural.block.RitualBlockEntity;
import net.salju.supernatural.compat.Thirst;
import net.salju.supernatural.entity.Spooky;
import net.salju.supernatural.events.SupernaturalManager;
import net.salju.supernatural.init.SupernaturalConfig;
import net.salju.supernatural.init.SupernaturalDamageTypes;
import net.salju.supernatural.init.SupernaturalEffects;
import net.salju.supernatural.init.SupernaturalItems;
import net.salju.supernatural.init.SupernaturalMobs;
import net.salju.supernatural.init.SupernaturalTags;

@EventBusSubscriber
public class SupernaturalEvents {
    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (SupernaturalManager.isVampire((LivingEntity)player)) {
            player.getFoodData().setSaturation(1.0f);
            player.getFoodData().setFoodLevel(20);
            Level level = player.level();
            if (level instanceof ServerLevel) {
                boolean check;
                ServerLevel lvl = (ServerLevel)level;
                SupernaturalManager.addVampireEffects(player);
                boolean bl = check = player.isInWaterRainOrBubble() || player.isInPowderSnow || player.wasInPowderSnow || player.isCreative() || (Boolean)SupernaturalConfig.SUN.get() != false || player.hasEffect(MobEffects.FIRE_RESISTANCE);
                if (lvl.isDay() && lvl.canSeeSky(BlockPos.containing((double)player.getX(), (double)player.getEyeY(), (double)player.getZ())) && !check) {
                    ItemStack helmet = player.getItemBySlot(EquipmentSlot.HEAD);
                    if (helmet.isEmpty()) {
                        if (player.getRemainingFireTicks() <= 20) {
                            player.setRemainingFireTicks(120);
                            player.hurt(SupernaturalDamageTypes.causeSunDamage(player.level().registryAccess()), 3.0f);
                        }
                    } else if (Mth.nextInt((RandomSource)player.getRandom(), (int)0, (int)25) <= 2) {
                        helmet.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.HEAD);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onHeal(LivingHealEvent event) {
        if (event.getAmount() <= 1.0f && SupernaturalManager.isVampire(event.getEntity())) {
            event.setAmount(event.getAmount() * (event.getEntity().hasEffect(MobEffects.REGENERATION) ? 0.45f : 0.15f));
        }
    }

    @SubscribeEvent
    public static void onRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        Entity entity;
        if (SupernaturalManager.isVampire((LivingEntity)event.getEntity()) && (entity = event.getTarget()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            if (event.getEntity().isCrouching() && !SupernaturalManager.isVampire(target) && target.isSleeping() && (target instanceof Player || target.getType().is(SupernaturalTags.BLOODY))) {
                event.getEntity().heal(6.0f);
                if (ModList.get().isLoaded("thirst")) {
                    Thirst.vampireBite(event.getEntity());
                }
                if (Math.random() <= (Double)SupernaturalConfig.BITE.get()) {
                    target.hurt(target.damageSources().source(DamageTypes.PLAYER_ATTACK, (Entity)event.getEntity()), 3.0f);
                    if (target instanceof Player) {
                        target.addEffect(new MobEffectInstance(SupernaturalEffects.VAMPIRISM, 24000, 0));
                    }
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.getEntity().hasEffect(SupernaturalEffects.POSSESSION)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        if (event.getEntity().hasEffect(SupernaturalEffects.POSSESSION)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onUseItemFinish(LivingEntityUseItemEvent.Finish event) {
        Player player;
        ItemStack stack = event.getItem();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && SupernaturalManager.isVampire((LivingEntity)(player = (Player)livingEntity)) && stack.is(Items.ENCHANTED_GOLDEN_APPLE) && player.getOffhandItem().is(Items.TOTEM_OF_UNDYING)) {
            player.level().broadcastEntityEvent((Entity)player, (byte)35);
            SupernaturalManager.setVampire(player, false);
            if (!player.isCreative()) {
                player.getOffhandItem().shrink(1);
            }
        }
    }

    @SubscribeEvent
    public static void onEffectAdded(MobEffectEvent.Applicable event) {
        if (SupernaturalManager.isVampire(event.getEntity()) && event.getEffectInstance() != null && (event.getEffectInstance().is(MobEffects.POISON) || event.getEffectInstance().is(MobEffects.HUNGER))) {
            event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
        }
    }

    @SubscribeEvent
    public static void onEffectRemoval(MobEffectEvent.Remove event) {
        Level level;
        if (event.getEffectInstance() != null && event.getEffectInstance().is(SupernaturalEffects.POSSESSION) && (level = event.getEntity().level()) instanceof ServerLevel) {
            ServerLevel lvl = (ServerLevel)level;
            ((EntityType)SupernaturalMobs.SPOOKY.get()).spawn(lvl, event.getEntity().blockPosition(), MobSpawnType.MOB_SUMMONED);
        }
    }

    @SubscribeEvent
    public static void onAttacked(LivingIncomingDamageEvent event) {
        LivingEntity target = event.getEntity();
        Entity entity = event.getSource().getDirectEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity source = (LivingEntity)entity;
            ItemStack weapon = source.getMainHandItem();
            if (SupernaturalManager.isVampire(target)) {
                int i = SupernaturalManager.getEnchantmentLevel(weapon, target.level(), "minecraft", "smite");
                if (weapon.is(Items.WOODEN_SWORD) && target.getHealth() <= target.getMaxHealth() * ((Double)SupernaturalConfig.WOOD.get()).floatValue()) {
                    event.setAmount(Float.MAX_VALUE);
                    Level level = target.level();
                    if (level instanceof ServerLevel) {
                        ServerLevel lvl = (ServerLevel)level;
                        EntityType.BAT.spawn(lvl, target.blockPosition(), MobSpawnType.MOB_SUMMONED);
                    }
                } else if (i > 0) {
                    if (target instanceof Player) {
                        event.setAmount(event.getAmount() + (float)i * 2.5f);
                    }
                } else if ((Double)SupernaturalConfig.DR.get() < 1.0) {
                    event.setAmount(event.getAmount() * ((Double)SupernaturalConfig.DR.get()).floatValue());
                }
            }
            if (SupernaturalManager.isVampire(source) && !SupernaturalManager.isVampire(target) && !target.getType().is(EntityTypeTags.UNDEAD) && !target.getType().is(SupernaturalTags.IMMUNITY)) {
                source.heal(((Double)SupernaturalConfig.LEECH.get()).floatValue() + 1.25f);
                if (source instanceof Player) {
                    ItemStack stack;
                    Player player = (Player)source;
                    if (((Boolean)SupernaturalConfig.BLOOD.get()).booleanValue() && (target instanceof Player || target.getType().is(SupernaturalTags.BLOODY)) && (stack = player.getOffhandItem()).is(Items.GLASS_BOTTLE)) {
                        if (!player.isCreative()) {
                            stack.shrink(1);
                        }
                        ItemStack blood = new ItemStack((ItemLike)SupernaturalItems.BLOOD.get());
                        if (!player.getInventory().add(blood)) {
                            player.drop(blood, false);
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onDeath(LivingDeathEvent event) {
        LivingEntity target = event.getEntity();
        Level level = target.level();
        if (level instanceof ServerLevel) {
            RitualBlockEntity block;
            ServerLevel lvl = (ServerLevel)level;
            if (target.hasEffect(SupernaturalEffects.POSSESSION)) {
                Spooky ghost = (Spooky)((EntityType)SupernaturalMobs.SPOOKY.get()).spawn(lvl, target.blockPosition(), MobSpawnType.MOB_SUMMONED);
                if (ghost != null) {
                    ghost.setPersistenceRequired();
                }
            } else if (lvl.dimensionType().natural() && target instanceof Mob && !target.getType().is(SupernaturalTags.IMMUNITY) && (block = SupernaturalManager.getAltar(target.blockPosition(), lvl, 12, Items.AMETHYST_SHARD)) != null) {
                block.setItem(0, SupernaturalManager.setSoul(new ItemStack((ItemLike)SupernaturalItems.SOULGEM.get()), target));
                lvl.sendParticles((ParticleOptions)ParticleTypes.SOUL, (double)block.getBlockPos().getX() + 0.5, (double)block.getBlockPos().getY() + 0.5, (double)block.getBlockPos().getZ() + 0.5, 6, 0.1, 0.15, 0.1, 0.0);
                lvl.sendParticles((ParticleOptions)ParticleTypes.SOUL, target.getX() + 0.5, target.getY() + 0.5, target.getZ() + 0.5, 8, 0.25, 0.35, 0.25, 0.0);
                target.getPersistentData().putBoolean("SoulTrapped", true);
            }
        }
    }

    @SubscribeEvent
    public static void onDrops(LivingDropsEvent event) {
        LivingEntity target = event.getEntity();
        if (target.level() instanceof ServerLevel && target.getPersistentData().getBoolean("SoulTrapped")) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onXpDrops(LivingExperienceDropEvent event) {
        LivingEntity target = event.getEntity();
        if (target.level() instanceof ServerLevel && target.getPersistentData().getBoolean("SoulTrapped")) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntitySpawned(EntityJoinLevelEvent event) {
        if (!event.loadedFromDisk()) {
            Entity target = event.getEntity();
            BlockPos pos = target.blockPosition();
            Level level = event.getLevel();
            if (level instanceof ServerLevel) {
                ServerLevel lvl = (ServerLevel)level;
                if (target instanceof Raider) {
                    Raider raidyr = (Raider)target;
                    if (((Boolean)SupernaturalConfig.RAIDERS.get()).booleanValue() && lvl.isNight() && raidyr.getCurrentRaid() != null && !raidyr.isPassenger() && !raidyr.isPatrolLeader() && raidyr instanceof Vindicator && Math.random() <= (Double)SupernaturalConfig.VAMPIRER.get()) {
                        ((EntityType)SupernaturalMobs.VAMPIRE.get()).spawn(lvl, pos, MobSpawnType.EVENT);
                        raidyr.getCurrentRaid().removeFromRaid(raidyr, true);
                        event.setCanceled(true);
                    }
                }
            }
        }
    }
}

