/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.rewithered.mixin;

import me.pajic.rewithered.Main;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractSkeleton.class})
public abstract class AbstractSkeletonMixin
extends Mob {
    protected AbstractSkeletonMixin(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"finalizeSpawn"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/monster/AbstractSkeleton;populateDefaultEquipmentEnchantments(Lnet/minecraft/world/level/ServerLevelAccessor;Lnet/minecraft/util/RandomSource;Lnet/minecraft/world/DifficultyInstance;)V")})
    private void assignWeapon(ServerLevelAccessor level, DifficultyInstance difficulty, EntitySpawnReason spawnType, SpawnGroupData spawnGroupData, CallbackInfoReturnable<SpawnGroupData> cir) {
        boolean isInFortress;
        boolean bl = isInFortress = level.getLevel().structureManager().getStructureAt(this.getOnPos(), (Structure)level.registryAccess().lookupOrThrow(Registries.STRUCTURE).getOrThrow(BuiltinStructures.FORTRESS).value()) != StructureStart.INVALID_START;
        if (this.getType() == EntityType.WITHER_SKELETON) {
            if (((Boolean)Main.CONFIG.witherSkeletonTweaks.useBowsInSoulSandValley.get()).booleanValue() && level.getBiome(this.getOnPos()).is(Biomes.SOUL_SAND_VALLEY) && !isInFortress && level.getRandom().nextFloat() < ((Float)Main.CONFIG.witherSkeletonTweaks.soulSandValleyBowChance.get()).floatValue() / 100.0f) {
                this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.BOW));
            } else if (((Boolean)Main.CONFIG.witherSkeletonTweaks.useBowsInFortress.get()).booleanValue() && isInFortress && level.getRandom().nextFloat() < ((Float)Main.CONFIG.witherSkeletonTweaks.fortressBowChance.get()).floatValue() / 100.0f) {
                Main.debugLog("Assigning bow to wither skeleton spawned in fortress at {} {} {}", this.getX(), this.getY(), this.getZ());
                this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.BOW));
            }
        }
    }
}

