/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.rewithered.mixin;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import me.pajic.rewithered.Main;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WitherSkeleton.class})
public abstract class WitherSkeletonMixin
extends Mob {
    protected WitherSkeletonMixin(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"populateDefaultEquipmentSlots"}, at={@At(value="HEAD")})
    private void spawnWitherSkeletonsWithArmor(RandomSource random, DifficultyInstance difficulty, CallbackInfo ci) {
        if (((Boolean)Main.CONFIG.witherSkeletonTweaks.spawnWithArmor.get()).booleanValue() && random.nextFloat() < 0.15f * difficulty.getSpecialMultiplier()) {
            float f;
            int i = random.nextInt(2);
            float f2 = f = this.level().getDifficulty() == Difficulty.HARD ? 0.1f : 0.25f;
            if (random.nextFloat() < 0.095f) {
                ++i;
            }
            if (random.nextFloat() < 0.095f) {
                ++i;
            }
            if (random.nextFloat() < 0.095f) {
                ++i;
            }
            boolean bl = true;
            for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                Item item;
                if (equipmentSlot.getType() != EquipmentSlot.Type.HUMANOID_ARMOR) continue;
                ItemStack itemStack = this.getItemBySlot(equipmentSlot);
                if (!bl && random.nextFloat() < f) break;
                bl = false;
                if (!itemStack.isEmpty() || (item = WitherSkeletonMixin.getEquipmentForSlot((EquipmentSlot)equipmentSlot, (int)i)) == null) continue;
                this.setItemSlot(equipmentSlot, new ItemStack((ItemLike)item));
            }
        }
    }

    @Inject(method={"populateDefaultEquipmentEnchantments"}, at={@At(value="HEAD")})
    private void enchantEquipmentOnWitherSkeletons(ServerLevelAccessor level, RandomSource random, DifficultyInstance difficulty, CallbackInfo ci) {
        if (((Boolean)Main.CONFIG.witherSkeletonTweaks.spawnWithEnchantedEquipment.get()).booleanValue()) {
            this.enchantSpawnedWeapon(level, random, difficulty);
            for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                if (equipmentSlot.getType() != EquipmentSlot.Type.HUMANOID_ARMOR) continue;
                this.enchantSpawnedArmor(level, random, equipmentSlot, difficulty);
            }
        }
    }

    @WrapWithCondition(method={"getArrow"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/AbstractArrow;igniteForSeconds(F)V")})
    private boolean replaceIgniteWithWitherEffect(AbstractArrow instance, float v) {
        if (((Boolean)Main.CONFIG.witherSkeletonTweaks.shootWitherArrows.get()).booleanValue() && instance instanceof Arrow) {
            Arrow arrow = (Arrow)instance;
            arrow.addEffect(new MobEffectInstance(MobEffects.WITHER, 100));
            return false;
        }
        return true;
    }
}

