/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.rewithered.potion;

import me.pajic.rewithered.Main;
import me.pajic.rewithered.potion.DecayPotion;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.Potions;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;
import net.neoforged.neoforge.registries.RegisterEvent;

public class ModPotions {
    public static final Potion DECAY = new DecayPotion((Integer)Main.CONFIG.decayPotion.duration.get() * 20, (Integer)Main.CONFIG.decayPotion.strength.get() - 1);
    public static final Potion LONG_DECAY = new DecayPotion((Integer)Main.CONFIG.decayPotion.longDuration.get() * 20, (Integer)Main.CONFIG.decayPotion.longStrength.get() - 1);
    public static final Potion STRONG_DECAY = new DecayPotion((Integer)Main.CONFIG.decayPotion.strongDuration.get() * 20, (Integer)Main.CONFIG.decayPotion.strongStrength.get() - 1);

    @SubscribeEvent
    public static void initPotions(RegisterEvent event) {
        event.register(Registries.POTION, registry -> {
            registry.register(Main.withModNamespace("decay"), (Object)DECAY);
            registry.register(Main.withModNamespace("long_decay"), (Object)LONG_DECAY);
            registry.register(Main.withModNamespace("strong_decay"), (Object)STRONG_DECAY);
        });
    }

    @SubscribeEvent
    public static void initBrewingRecipes(RegisterBrewingRecipesEvent event) {
        PotionBrewing.Builder builder = event.getBuilder();
        builder.addMix(Potions.AWKWARD, Items.WITHER_ROSE, BuiltInRegistries.POTION.wrapAsHolder((Object)DECAY));
        builder.addMix(BuiltInRegistries.POTION.wrapAsHolder((Object)DECAY), Items.REDSTONE, BuiltInRegistries.POTION.wrapAsHolder((Object)LONG_DECAY));
        builder.addMix(BuiltInRegistries.POTION.wrapAsHolder((Object)DECAY), Items.GLOWSTONE_DUST, BuiltInRegistries.POTION.wrapAsHolder((Object)STRONG_DECAY));
    }
}

