/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar;

import com.lightning.northstar.Northstar;
import com.lightning.northstar.block.tech.rocket_controls.RocketControlsClientHandler;
import com.lightning.northstar.client.renderer.armor.SpaceSuitLayerRenderer;
import com.lightning.northstar.client.renderer.effect.MarsEffects;
import com.lightning.northstar.client.renderer.effect.SpaceEffects;
import com.lightning.northstar.client.renderer.effect.VenusEffects;
import com.lightning.northstar.content.NorthstarDataComponents;
import com.lightning.northstar.content.NorthstarFluids;
import com.lightning.northstar.content.NorthstarTags;
import com.lightning.northstar.item.armor.RemainingOxygenOverlay;
import com.lightning.northstar.particle.NorthstarParticles;
import com.lightning.northstar.ponder.NorthstarPonderPlugin;
import com.lightning.northstar.util.NorthstarLang;
import com.lightning.northstar.world.dimension.NorthstarDimensions;
import net.createmod.catnip.lang.LangNumberFormat;
import net.createmod.ponder.api.registration.PonderPlugin;
import net.createmod.ponder.foundation.PonderIndex;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterDimensionSpecialEffectsEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;

@EventBusSubscriber(modid="northstar", value={Dist.CLIENT})
public class NorthstarClient {
    public static void onCtorClient(IEventBus modEventBus) {
        modEventBus.addListener(NorthstarParticles::registerFactories);
        PonderIndex.addPlugin((PonderPlugin)new NorthstarPonderPlugin());
    }

    @SubscribeEvent
    public static void onRegisterDimensionEffects(RegisterDimensionSpecialEffectsEvent event) {
        event.register(NorthstarDimensions.SPACE_EFFECTS, (DimensionSpecialEffects)new SpaceEffects());
        event.register(NorthstarDimensions.MARS_EFFECTS, (DimensionSpecialEffects)new MarsEffects());
        event.register(NorthstarDimensions.VENUS_EFFECTS, (DimensionSpecialEffects)new VenusEffects());
    }

    @SubscribeEvent
    public static void addEntityRendererLayers(EntityRenderersEvent.AddLayers event) {
        EntityRenderDispatcher dispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        SpaceSuitLayerRenderer.registerOnAll(dispatcher);
    }

    @SubscribeEvent
    public static void registerRenderers(FMLClientSetupEvent event) {
        ItemBlockRenderTypes.setRenderLayer((Fluid)((BaseFlowingFluid.Flowing)NorthstarFluids.SULFURIC_ACID.get()).getSource(), (RenderType)RenderType.translucent());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)NorthstarFluids.SULFURIC_ACID.get()), (RenderType)RenderType.translucent());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((BaseFlowingFluid.Flowing)NorthstarFluids.LIQUID_HYDROGEN.get()).getSource(), (RenderType)RenderType.translucent());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)NorthstarFluids.LIQUID_HYDROGEN.get()), (RenderType)RenderType.translucent());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((BaseFlowingFluid.Flowing)NorthstarFluids.LIQUID_OXYGEN.get()).getSource(), (RenderType)RenderType.translucent());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)NorthstarFluids.LIQUID_OXYGEN.get()), (RenderType)RenderType.translucent());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((BaseFlowingFluid.Flowing)NorthstarFluids.METHANE.get()).getSource(), (RenderType)RenderType.translucent());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)NorthstarFluids.METHANE.get()), (RenderType)RenderType.translucent());
    }

    @SubscribeEvent
    public static void registerGuiOverlays(RegisterGuiLayersEvent event) {
        event.registerAbove(VanillaGuiLayers.AIR_LEVEL, Northstar.asResource("remaining_oxygen"), (LayeredDraw.Layer)RemainingOxygenOverlay.INSTANCE);
    }

    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (!NorthstarTags.NorthstarItemTags.OXYGEN_SOURCES.matches(stack)) {
            return;
        }
        MutableComponent tooltip = Component.translatable((String)"northstar.gui.tooltip.oxygen").append(LangNumberFormat.format((double)((Integer)stack.getOrDefault(NorthstarDataComponents.OXYGEN, (Object)0)).intValue())).append((Component)NorthstarLang.MB.component()).withStyle(ChatFormatting.GRAY);
        event.getToolTip().add(1, tooltip);
    }

    @SubscribeEvent
    public static void onTick(ClientTickEvent.Pre event) {
        RocketControlsClientHandler.tick();
    }
}

