/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.accessor;

import com.lightning.northstar.client.TilingAnchor;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public interface NorthstarGuiGraphics {
    private GuiGraphics self() {
        return (GuiGraphics)this;
    }

    default public void northstar$blitRepeating(TextureAtlasSprite sprite, int x, int y, int w, int h, TilingAnchor anchor) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)sprite.atlasLocation());
        RenderSystem.enableBlend();
        BufferBuilder vertexBuffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        Matrix4f m = this.self().pose().last().pose();
        SpriteContents contents = sprite.contents();
        int spriteW = contents.width();
        int spriteH = contents.height();
        int tileCountX = w / spriteW;
        int remainderX = w - tileCountX * spriteW;
        int tileCountY = h / spriteH;
        int remainderY = h - tileCountY * spriteH;
        float uMin = sprite.getU0();
        float uMax = sprite.getU1();
        float vMin = sprite.getV0();
        float vMax = sprite.getV1();
        float diffU = uMax - uMin;
        float diffV = vMax - vMin;
        block0: for (int tileX = 0; tileX <= tileCountX; ++tileX) {
            float localU1;
            float localU0;
            int tileW;
            int n = tileW = tileX == tileCountX ? remainderX : spriteW;
            if (tileW == 0) break;
            int clippedX = spriteW - tileW;
            int drawX = x + tileX * spriteW;
            int nextX = drawX + spriteW - clippedX;
            float clippedU = diffU * (float)clippedX / (float)spriteW;
            if (anchor.left) {
                localU0 = uMin;
                localU1 = uMax - clippedU;
            } else {
                localU0 = uMin + clippedU;
                localU1 = uMax;
            }
            for (int tileY = 0; tileY <= tileCountY; ++tileY) {
                float localV1;
                float localV0;
                int tileH;
                int n2 = tileH = tileY == tileCountY ? remainderY : spriteH;
                if (tileH == 0) continue block0;
                int clippedY = spriteH - tileH;
                int drawY = y + tileY * spriteH;
                int nextY = drawY + spriteH - clippedY;
                float clippedV = diffV * (float)clippedY / (float)spriteH;
                if (anchor.bottom) {
                    localV0 = vMin + clippedV;
                    localV1 = vMax;
                } else {
                    localV0 = vMin;
                    localV1 = vMax - clippedV;
                }
                vertexBuffer.addVertex(m, (float)drawX, (float)nextY, 0.0f).setUv(localU0, localV0);
                vertexBuffer.addVertex(m, (float)nextX, (float)nextY, 0.0f).setUv(localU1, localV0);
                vertexBuffer.addVertex(m, (float)nextX, (float)drawY, 0.0f).setUv(localU1, localV1);
                vertexBuffer.addVertex(m, (float)drawX, (float)drawY, 0.0f).setUv(localU0, localV1);
            }
        }
        BufferUploader.drawWithShader((MeshData)vertexBuffer.buildOrThrow());
        RenderSystem.disableBlend();
    }
}

