/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.simple;

import com.google.common.collect.ImmutableMap;
import com.lightning.northstar.content.NorthstarBlocks;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.MultifaceSpreader;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FrostBlock
extends MultifaceBlock {
    public static final MapCodec<FrostBlock> CODEC = FrostBlock.simpleCodec(FrostBlock::new);
    public static final BooleanProperty UP = PipeBlock.UP;
    public static final BooleanProperty DOWN = PipeBlock.DOWN;
    public static final BooleanProperty NORTH = PipeBlock.NORTH;
    public static final BooleanProperty EAST = PipeBlock.EAST;
    public static final BooleanProperty SOUTH = PipeBlock.SOUTH;
    public static final BooleanProperty WEST = PipeBlock.WEST;
    public static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = (Map)PipeBlock.PROPERTY_BY_DIRECTION.entrySet().stream().collect(Util.toMap());
    protected static final float AABB_OFFSET = 1.0f;
    private static final VoxelShape UP_AABB = Block.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape DOWN_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private static final VoxelShape WEST_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_AABB = Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final VoxelShape SOUTH_AABB = Block.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    public final MultifaceSpreader spreader = new MultifaceSpreader((MultifaceBlock)this);
    private final Map<BlockState, VoxelShape> shapesCache;

    public FrostBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)UP, (Comparable)Boolean.FALSE)).setValue((Property)DOWN, (Comparable)Boolean.FALSE)).setValue((Property)NORTH, (Comparable)Boolean.FALSE)).setValue((Property)EAST, (Comparable)Boolean.FALSE)).setValue((Property)SOUTH, (Comparable)Boolean.FALSE)).setValue((Property)WEST, (Comparable)Boolean.FALSE));
        this.shapesCache = ImmutableMap.copyOf(this.stateDefinition.getPossibleStates().stream().collect(Collectors.toMap(Function.identity(), FrostBlock::calculateShape)));
    }

    protected MapCodec<? extends MultifaceBlock> codec() {
        return CODEC;
    }

    private static VoxelShape calculateShape(BlockState p_57906_) {
        VoxelShape voxelshape = Shapes.empty();
        if (((Boolean)p_57906_.getValue((Property)UP)).booleanValue()) {
            voxelshape = UP_AABB;
        }
        if (((Boolean)p_57906_.getValue((Property)NORTH)).booleanValue()) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)NORTH_AABB);
        }
        if (((Boolean)p_57906_.getValue((Property)SOUTH)).booleanValue()) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)SOUTH_AABB);
        }
        if (((Boolean)p_57906_.getValue((Property)EAST)).booleanValue()) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)EAST_AABB);
        }
        if (((Boolean)p_57906_.getValue((Property)WEST)).booleanValue()) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)WEST_AABB);
        }
        if (((Boolean)p_57906_.getValue((Property)DOWN)).booleanValue()) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)DOWN_AABB);
        }
        return voxelshape.isEmpty() ? Shapes.block() : voxelshape;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.shapesCache.get(pState);
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rando) {
    }

    public static boolean isAcceptableNeighbour(BlockGetter pBlockReader, BlockPos pNeighborPos, Direction pAttachedFace) {
        return MultifaceBlock.canAttachTo((BlockGetter)pBlockReader, (Direction)pAttachedFace, (BlockPos)pNeighborPos, (BlockState)pBlockReader.getBlockState(pNeighborPos));
    }

    public static BlockState giveStateValues(LevelAccessor level, BlockPos pPos, RandomSource rando) {
        ArrayList<Direction> list = new ArrayList<Direction>();
        for (Direction dir : Direction.values()) {
            BlockState block = level.getBlockState(pPos.relative(dir));
            if (!block.isAir()) continue;
            list.add(dir);
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((FrostBlock)((Object)NorthstarBlocks.FROST.get())).defaultBlockState().setValue((Property)UP, (Comparable)Boolean.valueOf(list.contains(Direction.UP)))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(list.contains(Direction.DOWN)))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(list.contains(Direction.NORTH)))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(list.contains(Direction.SOUTH)))).setValue((Property)EAST, (Comparable)Boolean.valueOf(list.contains(Direction.EAST)))).setValue((Property)WEST, (Comparable)Boolean.valueOf(list.contains(Direction.WEST)));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockState blockstate = pContext.getLevel().getBlockState(pContext.getClickedPos());
        boolean flag = blockstate.is((Block)this);
        BlockState blockstate1 = flag ? blockstate : this.defaultBlockState();
        for (Direction direction : pContext.getNearestLookingDirections()) {
            boolean flag1;
            BooleanProperty booleanproperty = FrostBlock.getPropertyForFace(direction);
            boolean bl = flag1 = flag && (Boolean)blockstate.getValue((Property)booleanproperty) != false;
            if (flag1 || !FrostBlock.canSupportAtFace((BlockGetter)pContext.getLevel(), pContext.getClickedPos(), direction)) continue;
            return (BlockState)blockstate1.setValue((Property)booleanproperty, (Comparable)Boolean.TRUE);
        }
        return flag ? blockstate1 : null;
    }

    public static BlockState getStateForGeneration(WorldGenLevel level, BlockPos pos, RandomSource rando) {
        BlockState newState = ((FrostBlock)((Object)NorthstarBlocks.FROST.get())).defaultBlockState();
        if (rando.nextInt(4) == 0) {
            newState = ((FrostBlock)((Object)NorthstarBlocks.FROST.get())).defaultBlockState();
        }
        int i = 0;
        for (Direction direction : Direction.values()) {
            BooleanProperty booleanproperty = FrostBlock.getPropertyForFace(direction);
            if (!((Boolean)newState.getValue((Property)booleanproperty)).booleanValue()) continue;
            boolean flag = FrostBlock.canSupportAtFace((BlockGetter)level, pos, direction);
            if (!flag) {
                flag = (newState.is((Block)NorthstarBlocks.FROST.get()) || newState.is((Block)NorthstarBlocks.FROST.get())) && (Boolean)newState.getValue((Property)booleanproperty) != false;
            }
            newState = (BlockState)newState.setValue((Property)booleanproperty, (Comparable)Boolean.valueOf(flag));
            if (flag) continue;
            ++i;
        }
        if (i == 0) {
            return null;
        }
        return newState;
    }

    private BlockState getUpdatedState(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        BlockPos blockpos = pPos.above();
        BlockState blockstate = null;
        for (Direction direction : Direction.values()) {
            BooleanProperty booleanproperty = FrostBlock.getPropertyForFace(direction);
            if (!((Boolean)pState.getValue((Property)booleanproperty)).booleanValue()) continue;
            boolean flag = FrostBlock.canSupportAtFace(pLevel, pPos, direction);
            if (!flag) {
                if (blockstate == null) {
                    blockstate = pLevel.getBlockState(blockpos);
                }
                flag = blockstate.is((Block)this) && (Boolean)blockstate.getValue((Property)booleanproperty) != false;
            }
            pState = (BlockState)pState.setValue((Property)booleanproperty, (Comparable)Boolean.valueOf(flag));
        }
        return pState;
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        BlockState blockstate = this.getUpdatedState(pState, (BlockGetter)pLevel, pCurrentPos);
        return !this.hasFaces(blockstate) ? Blocks.AIR.defaultBlockState() : blockstate;
    }

    private boolean hasFaces(BlockState pState) {
        return this.countFaces(pState) > 0;
    }

    private int countFaces(BlockState pState) {
        int i = 0;
        for (BooleanProperty booleanproperty : PROPERTY_BY_DIRECTION.values()) {
            if (!((Boolean)pState.getValue((Property)booleanproperty)).booleanValue()) continue;
            ++i;
        }
        return i;
    }

    private static boolean canSupportAtFace(BlockGetter pLevel, BlockPos pPos, Direction pDirection) {
        BlockPos blockpos = pPos.relative(pDirection);
        if (FrostBlock.isAcceptableNeighbour(pLevel, blockpos, pDirection)) {
            return true;
        }
        if (pDirection.getAxis() == Direction.Axis.Y) {
            return false;
        }
        BooleanProperty booleanproperty = PROPERTY_BY_DIRECTION.get(pDirection);
        BlockState blockstate = pLevel.getBlockState(pPos.above());
        return (blockstate.is((Block)NorthstarBlocks.MARS_ROOTS.get()) || blockstate.is((Block)NorthstarBlocks.GLOWING_MARS_ROOTS.get())) && (Boolean)blockstate.getValue((Property)booleanproperty) != false;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{UP, DOWN, NORTH, EAST, SOUTH, WEST});
    }

    public static BooleanProperty getPropertyForFace(Direction pFace) {
        return PROPERTY_BY_DIRECTION.get(pFace);
    }

    public MultifaceSpreader getSpreader() {
        return this.spreader;
    }
}

