/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.simple;

import com.lightning.northstar.block.simple.VentBlock;
import com.lightning.northstar.content.NorthstarBlocks;
import com.lightning.northstar.world.sealer.SealableBlock;
import com.lightning.northstar.world.sealer.SealingMode;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.utility.DyeHelper;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class InsulatedVentBlock
extends VentBlock
implements SealableBlock,
IWrenchable {
    public static final Property<DyeColor> COLOR = EnumProperty.create((String)"color", DyeColor.class);

    public InsulatedVentBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(COLOR, (Comparable)DyeColor.WHITE));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{COLOR}));
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return new ItemStack(NorthstarBlocks.VENT);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        super.onRemove(state, level, pos, newState, movedByPiston);
        if (newState.getBlock() instanceof VentBlock || movedByPiston) {
            return;
        }
        InsulatedVentBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack(DyeHelper.getWoolOfDye((DyeColor)((DyeColor)state.getValue(COLOR)))));
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        if (state.hasProperty(COLOR)) {
            Level level = context.getLevel();
            BlockPos pos = context.getClickedPos();
            IWrenchable.playRemoveSound((Level)level, (BlockPos)pos);
            InsulatedVentBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack(DyeHelper.getWoolOfDye((DyeColor)((DyeColor)state.getValue(COLOR)))));
            level.setBlock(pos, ((VentBlock)((Object)NorthstarBlocks.VENT.get())).withPropertiesOf(state), 3);
            return InteractionResult.SUCCESS;
        }
        return super.onSneakWrenched(state, context);
    }

    @Override
    public boolean northstar$isFaceSealed(BlockGetter level, BlockPos pos, BlockState state, Direction direction, boolean source, SealingMode mode) {
        return mode == SealingMode.TEMPERATURE;
    }

    public static void generateBlockStateModel(DataGenContext<Block, InsulatedVentBlock> context, RegistrateBlockstateProvider provider) {
        provider.getVariantBuilder((Block)context.get()).forAllStatesExcept(state -> {
            DyeColor color = (DyeColor)state.getValue(COLOR);
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)provider.models().withExistingParent("block/vent_insulated_" + color.getName(), provider.modLoc("block/vent_insulated"))).texture("wool", ResourceLocation.withDefaultNamespace((String)("block/" + color.getName() + "_wool")))).build();
        }, new Property[]{WATERLOGGED});
    }
}

