/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.simple;

import com.lightning.northstar.content.NorthstarBlocks;
import com.mojang.serialization.MapCodec;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.MultifaceSpreader;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class MarsRootBlock
extends MultifaceBlock
implements BonemealableBlock {
    public static final MapCodec<MarsRootBlock> CODEC = MarsRootBlock.simpleCodec(MarsRootBlock::new);
    public final MultifaceSpreader spreader = new MultifaceSpreader((MultifaceSpreader.SpreadConfig)new MultifaceSpreader.DefaultSpreaderConfig(this, this){

        @Nullable
        public BlockState getStateForPlacement(BlockState currentState, BlockGetter level, BlockPos pos, Direction lookingDirection) {
            MarsRootBlock marsRootBlock;
            Block block = currentState.getBlock();
            if (block instanceof MarsRootBlock) {
                MarsRootBlock b;
                marsRootBlock = b = (MarsRootBlock)block;
            } else {
                float f;
                if (level instanceof Level) {
                    Level l = (Level)level;
                    f = l.random.nextFloat();
                } else {
                    f = (float)Math.random();
                }
                marsRootBlock = f < 0.2f ? (MarsRootBlock)((Object)NorthstarBlocks.GLOWING_MARS_ROOTS.get()) : (MarsRootBlock)((Object)NorthstarBlocks.MARS_ROOTS.get());
            }
            MarsRootBlock block2 = marsRootBlock;
            return block2.getStateForPlacement(currentState, level, pos, lookingDirection);
        }
    });

    public MarsRootBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends MultifaceBlock> codec() {
        return CODEC;
    }

    public MultifaceSpreader getSpreader() {
        return this.spreader;
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return true;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        this.spreader.spreadAll(state, (LevelAccessor)level, pos, false);
    }
}

