/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.simple;

import com.lightning.northstar.content.NorthstarBlocks;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public class PointedCrimsiteBlock
extends PointedDripstoneBlock {
    public PointedCrimsiteBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        Direction direction;
        BlockPos blockpos;
        Level levelaccessor = pContext.getLevel();
        Direction direction1 = PointedCrimsiteBlock.calculateTipDirection((LevelReader)levelaccessor, blockpos = pContext.getClickedPos(), direction = pContext.getNearestLookingVerticalDirection().getOpposite());
        if (direction1 == null) {
            return null;
        }
        boolean flag = !pContext.isSecondaryUseActive();
        DripstoneThickness dripstonethickness = PointedCrimsiteBlock.calculateDripstoneThickness((LevelReader)levelaccessor, blockpos, direction1, flag);
        return dripstonethickness == null ? null : (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)TIP_DIRECTION, (Comparable)direction1)).setValue((Property)THICKNESS, (Comparable)dripstonethickness)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(levelaccessor.getFluidState(blockpos).getType() == Fluids.WATER));
    }

    private static DripstoneThickness calculateDripstoneThickness(LevelReader pLevel, BlockPos pPos, Direction pDir, boolean pIsTipMerge) {
        Direction direction = pDir.getOpposite();
        BlockState blockstate = pLevel.getBlockState(pPos.relative(pDir));
        if (PointedCrimsiteBlock.isPointedDripstoneWithDirection(blockstate, direction)) {
            return !pIsTipMerge && blockstate.getValue((Property)THICKNESS) != DripstoneThickness.TIP_MERGE ? DripstoneThickness.TIP : DripstoneThickness.TIP_MERGE;
        }
        if (!PointedCrimsiteBlock.isPointedDripstoneWithDirection(blockstate, pDir)) {
            return DripstoneThickness.TIP;
        }
        DripstoneThickness dripstonethickness = (DripstoneThickness)blockstate.getValue((Property)THICKNESS);
        if (dripstonethickness != DripstoneThickness.TIP && dripstonethickness != DripstoneThickness.TIP_MERGE) {
            BlockState blockstate1 = pLevel.getBlockState(pPos.relative(direction));
            return !PointedCrimsiteBlock.isPointedDripstoneWithDirection(blockstate1, pDir) ? DripstoneThickness.BASE : DripstoneThickness.MIDDLE;
        }
        return DripstoneThickness.FRUSTUM;
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (PointedCrimsiteBlock.isStalagmite(pState) && !this.canSurvive(pState, (LevelReader)pLevel, pPos)) {
            pLevel.destroyBlock(pPos, true);
        } else {
            PointedCrimsiteBlock.spawnFallingStalactite(pState, pLevel, pPos);
        }
    }

    private static void spawnFallingStalactite(BlockState pState, ServerLevel pLevel, BlockPos pPos) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pPos.mutable();
        BlockState blockstate = pState;
        while (PointedCrimsiteBlock.isStalactite(blockstate)) {
            FallingBlockEntity fallingblockentity = FallingBlockEntity.fall((Level)pLevel, (BlockPos)blockpos$mutableblockpos, (BlockState)blockstate);
            if (PointedCrimsiteBlock.isTip(blockstate, true)) {
                int i = Math.max(1 + pPos.getY() - blockpos$mutableblockpos.getY(), 6);
                float f = 1.0f * (float)i;
                fallingblockentity.setHurtsEntities(f, 40);
                break;
            }
            blockpos$mutableblockpos.move(Direction.DOWN);
            blockstate = pLevel.getBlockState((BlockPos)blockpos$mutableblockpos);
        }
    }

    private static boolean isTip(BlockState pState, boolean pIsTipMerge) {
        if (!pState.is((Block)NorthstarBlocks.POINTED_CRIMSITE.get())) {
            return false;
        }
        DripstoneThickness dripstonethickness = (DripstoneThickness)pState.getValue((Property)THICKNESS);
        return dripstonethickness == DripstoneThickness.TIP || pIsTipMerge && dripstonethickness == DripstoneThickness.TIP_MERGE;
    }

    private static boolean isStalactite(BlockState pState) {
        return PointedCrimsiteBlock.isPointedDripstoneWithDirection(pState, Direction.DOWN);
    }

    private static boolean isStalagmite(BlockState pState) {
        return PointedCrimsiteBlock.isPointedDripstoneWithDirection(pState, Direction.UP);
    }

    @Nullable
    private static Direction calculateTipDirection(LevelReader pLevel, BlockPos pPos, Direction pDir) {
        Direction direction;
        if (PointedCrimsiteBlock.isValidPointedDripstonePlacement(pLevel, pPos, pDir)) {
            direction = pDir;
        } else {
            if (!PointedCrimsiteBlock.isValidPointedDripstonePlacement(pLevel, pPos, pDir.getOpposite())) {
                return null;
            }
            direction = pDir.getOpposite();
        }
        return direction;
    }

    private static boolean isValidPointedDripstonePlacement(LevelReader pLevel, BlockPos pPos, Direction pDir) {
        BlockPos blockpos = pPos.relative(pDir.getOpposite());
        BlockState blockstate = pLevel.getBlockState(blockpos);
        return blockstate.isFaceSturdy((BlockGetter)pLevel, blockpos, pDir) || PointedCrimsiteBlock.isPointedDripstoneWithDirection(blockstate, pDir);
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return PointedCrimsiteBlock.isValidPointedDripstonePlacement(pLevel, pPos, (Direction)pState.getValue((Property)TIP_DIRECTION));
    }

    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
    }

    private static boolean isPointedDripstoneWithDirection(BlockState pState, Direction pDir) {
        return pState.is((Block)NorthstarBlocks.POINTED_CRIMSITE.get()) && pState.getValue((Property)TIP_DIRECTION) == pDir;
    }

    public static void growPointedDripstone(LevelAccessor pLevel, BlockPos pPos, Direction pDirection, int pHeight, boolean pMergeTip, Block block) {
        if (pLevel.getBlockState(pPos.relative(pDirection.getOpposite())).isSolidRender((BlockGetter)pLevel, pPos.relative(pDirection.getOpposite()))) {
            BlockPos.MutableBlockPos blockpos$mutableblockpos = pPos.mutable();
            PointedCrimsiteBlock.buildBaseToTipColumn(pDirection, pHeight, pMergeTip, p_190846_ -> {
                if (p_190846_.is(block)) {
                    p_190846_ = (BlockState)p_190846_.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(pLevel.isWaterAt((BlockPos)blockpos$mutableblockpos)));
                }
                if (!pLevel.getBlockState((BlockPos)blockpos$mutableblockpos).isSolidRender((BlockGetter)pLevel, (BlockPos)blockpos$mutableblockpos)) {
                    pLevel.setBlock((BlockPos)blockpos$mutableblockpos, p_190846_, 2);
                }
                blockpos$mutableblockpos.move(pDirection);
                if (!pLevel.getBlockState((BlockPos)blockpos$mutableblockpos).isAir()) {
                    return;
                }
            }, block);
        }
    }

    protected static void buildBaseToTipColumn(Direction pDirection, int pHeight, boolean pMergeTip, Consumer<BlockState> pBlockSetter, Block block) {
        if (pHeight >= 3) {
            pBlockSetter.accept(PointedCrimsiteBlock.createPointedDripstone(pDirection, DripstoneThickness.BASE, block));
            for (int i = 0; i < pHeight - 3; ++i) {
                pBlockSetter.accept(PointedCrimsiteBlock.createPointedDripstone(pDirection, DripstoneThickness.MIDDLE, block));
            }
        }
        if (pHeight >= 2) {
            pBlockSetter.accept(PointedCrimsiteBlock.createPointedDripstone(pDirection, DripstoneThickness.FRUSTUM, block));
        }
        if (pHeight >= 1) {
            pBlockSetter.accept(PointedCrimsiteBlock.createPointedDripstone(pDirection, pMergeTip ? DripstoneThickness.TIP_MERGE : DripstoneThickness.TIP, block));
        }
    }

    private static BlockState createPointedDripstone(Direction pDirection, DripstoneThickness pDripstoneThickness, Block block) {
        return (BlockState)((BlockState)block.defaultBlockState().setValue((Property)TIP_DIRECTION, (Comparable)pDirection)).setValue((Property)THICKNESS, (Comparable)pDripstoneThickness);
    }

    public BlockState updateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        if (((Boolean)pState.getValue((Property)WATERLOGGED)).booleanValue()) {
            pLevel.scheduleTick(pCurrentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)pLevel));
        }
        if (pDirection != Direction.UP && pDirection != Direction.DOWN) {
            return pState;
        }
        Direction direction = (Direction)pState.getValue((Property)TIP_DIRECTION);
        if (direction == Direction.DOWN && pLevel.getBlockTicks().hasScheduledTick(pCurrentPos, (Object)this)) {
            return pState;
        }
        if (pDirection == direction.getOpposite() && !this.canSurvive(pState, (LevelReader)pLevel, pCurrentPos)) {
            if (direction == Direction.DOWN) {
                pLevel.scheduleTick(pCurrentPos, (Block)this, 2);
            } else {
                pLevel.scheduleTick(pCurrentPos, (Block)this, 1);
            }
            return pState;
        }
        boolean flag = pState.getValue((Property)THICKNESS) == DripstoneThickness.TIP_MERGE;
        DripstoneThickness dripstonethickness = PointedCrimsiteBlock.calculateDripstoneThickness((LevelReader)pLevel, pCurrentPos, direction, flag);
        return (BlockState)pState.setValue((Property)THICKNESS, (Comparable)dripstonethickness);
    }
}

