/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.simple;

import com.lightning.northstar.block.simple.GrateBlock;
import com.lightning.northstar.block.simple.InsulatedVentBlock;
import com.lightning.northstar.content.NorthstarBlocks;
import com.simibubi.create.foundation.utility.DyeHelper;
import java.util.Arrays;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class VentBlock
extends GrateBlock {
    public VentBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected ItemInteractionResult useItemOn(ItemStack item, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        DyeColor color;
        if (!item.isEmpty() && item.is(ItemTags.WOOL) && (color = (DyeColor)Arrays.stream(DyeColor.values()).filter(dye -> DyeHelper.getWoolOfDye((DyeColor)dye).asItem() == item.getItem()).findFirst().orElse(null)) != null) {
            if (state.hasProperty(InsulatedVentBlock.COLOR)) {
                if (state.getValue(InsulatedVentBlock.COLOR) == color) {
                    return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
                VentBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack(DyeHelper.getWoolOfDye((DyeColor)((DyeColor)state.getValue(InsulatedVentBlock.COLOR)))));
            }
            BlockState newState = (BlockState)((InsulatedVentBlock)NorthstarBlocks.INSULATED_VENT.get()).withPropertiesOf(state).setValue(InsulatedVentBlock.COLOR, (Comparable)color);
            level.setBlock(pos, newState, 3);
            if (!player.isCreative()) {
                item.setCount(item.getCount() - 1);
            }
            player.setItemInHand(hand, item);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useItemOn(item, state, level, pos, player, hand, hitResult);
    }
}

