/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.simple;

import com.lightning.northstar.block.entity.VenusExhaustBlockEntity;
import com.lightning.northstar.content.NorthstarBlockEntityTypes;
import com.lightning.northstar.particle.NorthstarParticles;
import com.mojang.serialization.MapCodec;
import com.simibubi.create.foundation.block.IBE;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class VenusSporeSpreaderBlock
extends BaseEntityBlock
implements IBE<VenusExhaustBlockEntity> {
    private static final MapCodec<VenusSporeSpreaderBlock> CODEC = VenusSporeSpreaderBlock.simpleCodec(VenusSporeSpreaderBlock::new);

    public VenusSporeSpreaderBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public static void makeParticles(Level level, BlockPos pos) {
        if (!level.random.nextBoolean()) {
            return;
        }
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        level.addAlwaysVisibleParticle((ParticleOptions)NorthstarParticles.SULFUR_POOF.get(), true, (double)x + 0.5, (double)(y + 2), (double)z + 0.5, 0.0, 0.0, 0.0);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int l = 0; l < 14 + level.random.nextInt(); ++l) {
            blockpos$mutableblockpos.set(x, y, z);
            BlockState blockstate = level.getBlockState((BlockPos)blockpos$mutableblockpos);
            if (blockstate.isCollisionShapeFullBlock((BlockGetter)level, (BlockPos)blockpos$mutableblockpos)) continue;
            level.addAlwaysVisibleParticle((ParticleOptions)NorthstarParticles.SULFUR_POOF.get(), true, (double)blockpos$mutableblockpos.getX() + level.random.nextDouble(), (double)blockpos$mutableblockpos.getY() + level.random.nextDouble(), (double)blockpos$mutableblockpos.getZ() + level.random.nextDouble(), 0.0, 0.0, 0.0);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return VenusSporeSpreaderBlock.createTickerHelper(pBlockEntityType, (BlockEntityType)((BlockEntityType)NorthstarBlockEntityTypes.VENUS_EXHAUST.get()), VenusExhaustBlockEntity::particleTick);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public Class<VenusExhaustBlockEntity> getBlockEntityClass() {
        return VenusExhaustBlockEntity.class;
    }

    public BlockEntityType<? extends VenusExhaustBlockEntity> getBlockEntityType() {
        return (BlockEntityType)NorthstarBlockEntityTypes.VENUS_EXHAUST.get();
    }
}

