/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.ice_box;

import com.lightning.northstar.block.tech.ice_box.IceBoxBlockEntity;
import com.lightning.northstar.item.NorthstarRecipeTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeParams;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.recipe.DummyCraftingContainer;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.data.Iterate;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import net.neoforged.neoforge.items.IItemHandler;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class FreezingRecipe
extends ProcessingRecipe<RecipeInput, Params> {
    protected int minTemperature;
    protected int maxTemperature;

    public static boolean match(IceBoxBlockEntity icebox, Recipe<?> recipe) {
        boolean matchFluid;
        if (!(recipe instanceof FreezingRecipe)) {
            return false;
        }
        FreezingRecipe r = (FreezingRecipe)recipe;
        boolean matchItem = r.results.isEmpty() || icebox.filtering.test(((ProcessingOutput)r.results.get(0)).getStack());
        boolean bl = matchFluid = r.fluidResults.isEmpty() || icebox.filtering.test((FluidStack)r.fluidResults.get(0));
        if (!matchItem && !matchFluid) {
            return false;
        }
        return FreezingRecipe.apply(icebox, recipe, true);
    }

    public static boolean apply(IceBoxBlockEntity icebox, Recipe<?> recipe) {
        return FreezingRecipe.apply(icebox, recipe, false);
    }

    private static boolean apply(IceBoxBlockEntity icebox, Recipe<?> recipe, boolean test) {
        NonNullList nonNullList;
        SmartInventory availableItems = icebox.inputInventory;
        IFluidHandler availableFluids = icebox.inputTank.getCapability();
        ArrayList<ItemStack> recipeOutputItems = new ArrayList<ItemStack>();
        ArrayList<FluidStack> recipeOutputFluids = new ArrayList<FluidStack>();
        LinkedList ingredients = new LinkedList(recipe.getIngredients());
        if (recipe instanceof ProcessingRecipe) {
            ProcessingRecipe r = (ProcessingRecipe)recipe;
            nonNullList = r.getFluidIngredients();
        } else {
            nonNullList = List.of();
        }
        NonNullList fluidIngredients = nonNullList;
        for (boolean simulate : Iterate.trueAndFalse) {
            Object ingredient2;
            if (!simulate && test) {
                return true;
            }
            int[] extractedItemsFromSlot = new int[availableItems.getSlots()];
            int[] extractedFluidsFromTank = new int[availableFluids.getTanks()];
            block1: for (Object ingredient2 : ingredients) {
                for (int slot = 0; slot < availableItems.getSlots(); ++slot) {
                    ItemStack extracted;
                    if (simulate && availableItems.getStackInSlot(slot).getCount() <= extractedItemsFromSlot[slot] || !ingredient2.test(extracted = availableItems.extractItem(slot, 1, true))) continue;
                    if (!simulate) {
                        availableItems.extractItem(slot, 1, false);
                    }
                    int n = slot;
                    extractedItemsFromSlot[n] = extractedItemsFromSlot[n] + 1;
                    continue block1;
                }
                return false;
            }
            boolean fluidsAffected = false;
            ingredient2 = fluidIngredients.iterator();
            block3: while (ingredient2.hasNext()) {
                SizedFluidIngredient fluidIngredient = (SizedFluidIngredient)ingredient2.next();
                int amountRequired = fluidIngredient.amount();
                for (int tank = 0; tank < availableFluids.getTanks(); ++tank) {
                    FluidStack fluidStack = availableFluids.getFluidInTank(tank);
                    if (simulate && fluidStack.getAmount() <= extractedFluidsFromTank[tank] || !fluidIngredient.test(fluidStack)) continue;
                    int drainedAmount = Math.min(amountRequired, fluidStack.getAmount());
                    if (!simulate) {
                        fluidStack.shrink(drainedAmount);
                        fluidsAffected = true;
                    }
                    if ((amountRequired -= drainedAmount) != 0) continue;
                    int n = tank;
                    extractedFluidsFromTank[n] = extractedFluidsFromTank[n] + drainedAmount;
                    continue block3;
                }
                return false;
            }
            if (fluidsAffected && !simulate) {
                ((SmartFluidTankBehaviour)icebox.getBehaviour(SmartFluidTankBehaviour.INPUT)).forEach(SmartFluidTankBehaviour.TankSegment::onFluidStackChanged);
                ((SmartFluidTankBehaviour)icebox.getBehaviour(SmartFluidTankBehaviour.OUTPUT)).forEach(SmartFluidTankBehaviour.TankSegment::onFluidStackChanged);
            }
            if (simulate && recipe instanceof FreezingRecipe) {
                FreezingRecipe r = (FreezingRecipe)recipe;
                CraftingInput remainderInput = new DummyCraftingContainer((IItemHandler)availableItems, extractedItemsFromSlot).asCraftInput();
                recipeOutputItems.addAll(r.rollResults(icebox.getLevel().random));
                recipeOutputFluids.addAll((Collection<FluidStack>)r.getFluidResults());
                recipeOutputItems.addAll((Collection<ItemStack>)r.getRemainingItems((RecipeInput)remainderInput));
            }
            if (icebox.acceptOutputs(recipeOutputItems, recipeOutputFluids, simulate)) continue;
            return false;
        }
        return true;
    }

    public FreezingRecipe(Params params) {
        super((IRecipeTypeInfo)NorthstarRecipeTypes.FREEZING, (ProcessingRecipeParams)params);
        if (params instanceof Params) {
            Params p = params;
            this.minTemperature = p.minTemperature;
            this.maxTemperature = p.maxTemperature;
        }
    }

    public boolean isTemperatureWithinRange(float temperature) {
        return temperature >= (float)this.minTemperature && temperature <= (float)this.maxTemperature;
    }

    protected int getMaxInputCount() {
        return 9;
    }

    protected int getMaxOutputCount() {
        return 4;
    }

    protected int getMaxFluidInputCount() {
        return 2;
    }

    protected int getMaxFluidOutputCount() {
        return 2;
    }

    protected boolean canSpecifyDuration() {
        return true;
    }

    public int getMinTemperature() {
        return this.minTemperature;
    }

    public int getMaxTemperature() {
        return this.maxTemperature;
    }

    public boolean matches(RecipeInput inv, @Nonnull Level worldIn) {
        return false;
    }

    public static class Params
    extends ProcessingRecipeParams {
        public static MapCodec<Params> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Params.codec(Params::new).forGetter(Function.identity()), (App)Codec.INT.optionalFieldOf("minTemperature", (Object)Integer.MIN_VALUE).forGetter(p -> p.minTemperature), (App)Codec.INT.optionalFieldOf("maxTemperature", (Object)Integer.MAX_VALUE).forGetter(p -> p.maxTemperature)).apply((Applicative)instance, (params, minTemperature, maxTemperature) -> {
            params.minTemperature = minTemperature;
            params.maxTemperature = maxTemperature;
            return params;
        }));
        public static StreamCodec<RegistryFriendlyByteBuf, Params> STREAM_CODEC = Params.streamCodec(Params::new);
        protected int minTemperature = Integer.MIN_VALUE;
        protected int maxTemperature = Integer.MAX_VALUE;

        protected void encode(RegistryFriendlyByteBuf buffer) {
            super.encode(buffer);
            buffer.writeVarInt(this.minTemperature);
            buffer.writeVarInt(this.maxTemperature);
        }

        protected void decode(RegistryFriendlyByteBuf buffer) {
            super.decode(buffer);
            this.minTemperature = buffer.readVarInt();
            this.maxTemperature = buffer.readVarInt();
        }
    }

    @MethodsReturnNonnullByDefault
    @ParametersAreNonnullByDefault
    public static class Serializer
    implements RecipeSerializer<FreezingRecipe> {
        private static final MapCodec<FreezingRecipe> CODEC = ProcessingRecipe.codec(FreezingRecipe::new, Params.CODEC);
        private static final StreamCodec<RegistryFriendlyByteBuf, FreezingRecipe> STREAMED_CODEC = ProcessingRecipe.streamCodec(FreezingRecipe::new, Params.STREAM_CODEC);

        public MapCodec<FreezingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, FreezingRecipe> streamCodec() {
            return STREAMED_CODEC;
        }
    }
}

