/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.oxygen_detector;

import com.lightning.northstar.block.tech.oxygen_detector.OxygenDetectorBlock;
import com.lightning.northstar.world.oxygen.NorthstarOxygen;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class OxygenDetectorBlockEntity
extends SmartBlockEntity {
    public OxygenDetectorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public void tick() {
        super.tick();
        BlockState state = this.getBlockState();
        Direction facing = (Direction)state.getValue((Property)OxygenDetectorBlock.FACING);
        BlockPos observed = this.worldPosition.relative(facing);
        boolean oxygenated = NorthstarOxygen.hasOxygen(this.level, (Vec3i)observed);
        if (oxygenated != (Boolean)state.getValue((Property)OxygenDetectorBlock.POWERED)) {
            this.level.setBlock(this.worldPosition, (BlockState)state.setValue((Property)OxygenDetectorBlock.POWERED, (Comparable)Boolean.valueOf(oxygenated)), 2);
            BlockPos powered = this.worldPosition.relative(facing.getOpposite());
            Block block = state.getBlock();
            this.level.neighborChanged(powered, block, this.worldPosition);
            this.level.updateNeighborsAtExceptFromFacing(powered, block, facing);
        }
    }
}

