/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.oxygen_filler;

import com.lightning.northstar.block.tech.oxygen_filler.OxygenFillerBlock;
import com.lightning.northstar.content.NorthstarBlockEntityTypes;
import com.lightning.northstar.content.NorthstarDataComponents;
import com.lightning.northstar.content.NorthstarFluids;
import com.lightning.northstar.content.NorthstarTags;
import com.lightning.northstar.util.NorthstarLang;
import com.lightning.northstar.world.oxygen.NorthstarOxygen;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class OxygenFillerBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    public final Container container = new SimpleContainer(1);
    public final IFluidHandler fluidHandler = new IFluidHandler(){

        public int getTanks() {
            return 1;
        }

        public FluidStack getFluidInTank(int tank) {
            ItemStack item = OxygenFillerBlockEntity.this.getContainedItem();
            if (tank == 0 || item == null || !item.has(NorthstarDataComponents.OXYGEN)) {
                return FluidStack.EMPTY;
            }
            int oxygen = (Integer)item.get(NorthstarDataComponents.OXYGEN);
            return oxygen == 0 ? FluidStack.EMPTY : new FluidStack((Fluid)NorthstarFluids.OXYGEN.get(), oxygen);
        }

        public int getTankCapacity(int tank) {
            return OxygenFillerBlockEntity.this.getContainedItem() == null ? 0 : 1800;
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return tank == 0 && NorthstarOxygen.isOxygen(stack.getFluid());
        }

        public int fill(FluidStack stack, IFluidHandler.FluidAction action) {
            ItemStack item = OxygenFillerBlockEntity.this.getContainedItem();
            if (!this.isFluidValid(0, stack) || item == null) {
                return 0;
            }
            int oxygen = item.has(NorthstarDataComponents.OXYGEN) ? (Integer)item.get(NorthstarDataComponents.OXYGEN) : 0;
            int fillable = Mth.clamp((int)(1800 - oxygen), (int)0, (int)stack.getAmount());
            if (action.execute() && fillable != 0) {
                item.set(NorthstarDataComponents.OXYGEN, (Object)(oxygen + fillable));
                OxygenFillerBlockEntity.this.sendData();
                if (oxygen + fillable >= 1800) {
                    AllSoundEvents.CONFIRM.playOnServer(OxygenFillerBlockEntity.this.level, (Vec3i)OxygenFillerBlockEntity.this.worldPosition, 0.4f, 0.0f);
                }
            }
            return fillable;
        }

        public FluidStack drain(FluidStack stack, IFluidHandler.FluidAction action) {
            if (!this.isFluidValid(0, stack)) {
                return FluidStack.EMPTY;
            }
            FluidStack drained = stack.copy();
            drained.setAmount(this.drainAmount(stack.getAmount(), action));
            return drained;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return new FluidStack((Fluid)NorthstarFluids.OXYGEN.get(), this.drainAmount(maxDrain, action));
        }

        private int drainAmount(int amount, IFluidHandler.FluidAction action) {
            ItemStack item = OxygenFillerBlockEntity.this.getContainedItem();
            if (item == null) {
                return 0;
            }
            int oxygen = item.has(NorthstarDataComponents.OXYGEN) ? (Integer)item.get(NorthstarDataComponents.OXYGEN) : 0;
            int drainable = Math.min(amount, oxygen);
            if (action.execute() && drainable != 0) {
                item.set(NorthstarDataComponents.OXYGEN, (Object)(oxygen - drainable));
                OxygenFillerBlockEntity.this.sendData();
            }
            return drainable;
        }
    };

    public OxygenFillerBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public void destroy() {
        super.destroy();
        ItemHelper.dropContents((Level)this.level, (BlockPos)this.worldPosition, (IItemHandler)new InvWrapper(this.container));
        this.container.clearContent();
    }

    @Nullable
    protected ItemStack getContainedItem() {
        ItemStack item = this.container.getItem(0);
        return NorthstarTags.NorthstarItemTags.OXYGEN_SOURCES.matches(item) ? item : null;
    }

    public void tick() {
        super.tick();
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        compound.put("item", this.container.getItem(0).saveOptional(registries));
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.container.setItem(0, ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)compound.getCompound("item")));
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        ItemStack item = this.container.getItem(0);
        if (item.isEmpty()) {
            return false;
        }
        NorthstarLang.translate("gui.goggles.oxygen_filler", new Object[0]).forGoggles(tooltip);
        CreateLang.itemName((ItemStack)item).style(ChatFormatting.GRAY).forGoggles(tooltip);
        if (NorthstarTags.NorthstarItemTags.OXYGEN_SOURCES.matches(item)) {
            int oxygen = item.has(NorthstarDataComponents.OXYGEN) ? (Integer)item.get(NorthstarDataComponents.OXYGEN) : 0;
            CreateLang.builder().add(CreateLang.number((double)oxygen).add(NorthstarLang.MB).style(ChatFormatting.GOLD)).text(ChatFormatting.GRAY, " / ").add(CreateLang.number((double)1800.0).add(NorthstarLang.MB).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        } else {
            CreateLang.text((String)"Cannot hold oxygen").style(ChatFormatting.RED).forGoggles(tooltip, 1);
        }
        return true;
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)NorthstarBlockEntityTypes.OXYGEN_FILLER.get(), (be, face) -> {
            if (face == null || face == ((Direction)be.getBlockState().getValue(OxygenFillerBlock.HORIZONTAL_FACING)).getOpposite()) {
                return be.fluidHandler;
            }
            return null;
        });
    }
}

