/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.rocket_controls;

import com.lightning.northstar.block.tech.rocket_controls.RocketControlsInputPacket;
import com.lightning.northstar.contraption.rocket.RocketContraptionEntity;
import com.mojang.blaze3d.platform.InputConstants;
import com.simibubi.create.foundation.utility.ControlsUtil;
import com.simibubi.create.foundation.utility.CreateLang;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.Nullable;

public class RocketControlsClientHandler {
    public static Set<Integer> currentlyPressed = new HashSet<Integer>();
    public static int PACKET_RATE = 5;
    private static int packetCooldown;
    private static int displaytime;
    private static int launchTime;
    private static WeakReference<RocketContraptionEntity> entityRef;
    private static BlockPos controlsPos;

    public static void levelUnloaded(LevelAccessor level) {
        packetCooldown = 0;
        entityRef = new WeakReference<Object>(null);
        controlsPos = null;
        currentlyPressed.clear();
    }

    public static void startControlling(RocketContraptionEntity rce, BlockPos controllerLocalPos) {
        entityRef = new WeakReference<RocketContraptionEntity>(rce);
        controlsPos = controllerLocalPos;
        displaytime = 0;
        if (rce != null && rce.isLaunchingOrLanding()) {
            Minecraft.getInstance().player.displayClientMessage((Component)CreateLang.translateDirect((String)"contraption.controls.start_controlling", (Object[])new Object[]{rce.getContraptionName()}), true);
        } else {
            Minecraft.getInstance().player.displayClientMessage((Component)Component.translatable((String)"northstar.contraption.controls.rocket_tut").withStyle(ChatFormatting.AQUA), true);
        }
    }

    public static void stopControlling() {
        ControlsUtil.getControls().forEach(kb -> kb.setDown(ControlsUtil.isActuallyPressed((KeyMapping)kb)));
        RocketContraptionEntity contrapEntity = (RocketContraptionEntity)((Object)entityRef.get());
        if (!currentlyPressed.isEmpty() && contrapEntity != null) {
            CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new RocketControlsInputPacket(new ArrayList<Integer>(currentlyPressed), false, contrapEntity.getId(), controlsPos, true));
        }
        packetCooldown = 0;
        entityRef = new WeakReference<Object>(null);
        controlsPos = null;
        currentlyPressed.clear();
        Minecraft.getInstance().player.displayClientMessage((Component)CreateLang.translateDirect((String)"contraption.controls.stop_controlling", (Object[])new Object[0]), true);
    }

    public static void tick() {
        RocketContraptionEntity rce = (RocketContraptionEntity)((Object)entityRef.get());
        LocalPlayer player = Minecraft.getInstance().player;
        if (rce == null || player == null) {
            return;
        }
        if (displaytime < 61) {
            ++displaytime;
        }
        if (rce.isActiveLaunch()) {
            if (Math.abs(rce.getLaunchTime() - launchTime) > 10) {
                launchTime = rce.getLaunchTime();
            }
            if (launchTime % 20 == 0 && launchTime != 0) {
                player.displayClientMessage((Component)Component.literal((String)("T-" + launchTime / 20)).withStyle(ChatFormatting.AQUA), true);
                player.level().playSound((Player)player, player.blockPosition(), (SoundEvent)SoundEvents.NOTE_BLOCK_PLING.value(), SoundSource.BLOCKS, 10.0f, launchTime / 20 == 0 ? 10.0f : 1.0f);
            }
            --launchTime;
        }
        if (rce.landingMode && rce.getY() < rce.getSlowdownHeightThreshold() && rce.getControllingPlayer().isPresent() && rce.getControllingPlayer().get() == player.getUUID()) {
            if (rce.auto_land_mode) {
                player.displayClientMessage((Component)Component.translatable((String)"northstar.contraption.controls.landing_notification").withStyle(ChatFormatting.RED), true);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"northstar.contraption.controls.landing_warning").withStyle(ChatFormatting.RED), true);
            }
        }
        if (packetCooldown > 0) {
            --packetCooldown;
        }
        if (rce.isRemoved() || InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)256)) {
            BlockPos pos = controlsPos;
            RocketControlsClientHandler.stopControlling();
            CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new RocketControlsInputPacket(new ArrayList<Integer>(currentlyPressed), false, rce.getId(), pos, true));
            return;
        }
        List controls = ControlsUtil.getControls();
        HashSet<Integer> pressedKeys = new HashSet<Integer>();
        for (int i = 0; i < controls.size(); ++i) {
            if (!ControlsUtil.isActuallyPressed((KeyMapping)((KeyMapping)controls.get(i)))) continue;
            pressedKeys.add(i);
        }
        rce.clientControl(controlsPos, pressedKeys, (Player)player);
        HashSet<Integer> newKeys = new HashSet<Integer>(pressedKeys);
        Set<Integer> releasedKeys = currentlyPressed;
        newKeys.removeAll(releasedKeys);
        releasedKeys.removeAll(pressedKeys);
        if (!releasedKeys.isEmpty()) {
            CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new RocketControlsInputPacket(new ArrayList<Integer>(currentlyPressed), false, rce.getId(), controlsPos, false));
        }
        if (!newKeys.isEmpty()) {
            CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new RocketControlsInputPacket(new ArrayList<Integer>(currentlyPressed), true, rce.getId(), controlsPos, false));
            packetCooldown = PACKET_RATE;
        }
        if (packetCooldown == 0) {
            CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new RocketControlsInputPacket(new ArrayList<Integer>(pressedKeys), true, rce.getId(), controlsPos, false));
            packetCooldown = PACKET_RATE;
        }
        if (!currentlyPressed.isEmpty()) {
            if (currentlyPressed.contains(4)) {
                // empty if block
            }
            if (currentlyPressed.contains(5)) {
                launchTime = -20;
                RocketControlsClientHandler.stopControlling();
            }
        }
        currentlyPressed = pressedKeys;
        controls.forEach(kb -> kb.setDown(false));
    }

    @Nullable
    public static RocketContraptionEntity getContraption() {
        return (RocketContraptionEntity)((Object)entityRef.get());
    }

    @Nullable
    public static BlockPos getControlsPos() {
        return controlsPos;
    }

    static {
        displaytime = 0;
        launchTime = 0;
        entityRef = new WeakReference<Object>(null);
    }
}

