/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.rocket_station;

import com.lightning.northstar.Northstar;
import com.lightning.northstar.block.tech.rocket_station.RocketStationBlock;
import com.lightning.northstar.block.tech.rocket_station.RocketStationMenu;
import com.lightning.northstar.config.NorthstarConfigs;
import com.lightning.northstar.content.NorthstarDataComponents;
import com.lightning.northstar.content.NorthstarItems;
import com.lightning.northstar.contraption.rocket.RocketContraption;
import com.lightning.northstar.contraption.rocket.RocketContraptionEntity;
import com.lightning.northstar.contraption.rocket.RocketHandler;
import com.lightning.northstar.world.dimension.NorthstarPlanets;
import com.lightning.northstar.world.sealer.ProgressiveBlockSealer;
import com.lightning.northstar.world.sealer.SealingMode;
import com.lightning.northstar.world.temperature.NorthstarTemperature;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.ContraptionCollider;
import com.simibubi.create.content.contraptions.ContraptionWorld;
import com.simibubi.create.content.contraptions.ControlledContraptionEntity;
import com.simibubi.create.content.contraptions.IControlContraption;
import com.simibubi.create.content.contraptions.IDisplayAssemblyExceptions;
import com.simibubi.create.content.contraptions.TranslatingContraption;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.content.trains.station.StationBlock;
import com.simibubi.create.content.trains.track.ITrackBlock;
import com.simibubi.create.content.trains.track.TrackTargetingBehaviour;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.createmod.catnip.data.WorldAttached;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;

public class RocketStationBlockEntity
extends SmartBlockEntity
implements IDisplayAssemblyExceptions,
IControlContraption,
MenuProvider {
    boolean assembleNextTick;
    public Player owner;
    protected AssemblyException lastException;
    public TrackTargetingBehaviour<GlobalStation> edgePoint;
    protected ItemStackHandler inventory;
    protected IItemHandlerModifiable itemCapability;
    public String name = "Bing Bong's Big Bonanza";
    protected int failedCarriageIndex;
    Direction assemblyDirection;
    int assemblyLength;
    public float offset;
    public int fuelCost;
    public int fuelReturnCost;
    public boolean running;
    public boolean needsContraption;
    public AbstractContraptionEntity movedContraption;
    protected boolean forceMove;
    protected ScrollOptionBehaviour<IControlContraption.MovementMode> movementMode;
    protected boolean waitingForSpeedChange;
    protected double sequencedOffsetLimit;
    int i = 0;
    protected float clientOffsetDiff;
    public ResourceKey<Level> target;
    public final Container container = new SimpleContainer(1);
    public static WorldAttached<Map<BlockPos, BoundingBox>> assemblyAreas = new WorldAttached(w -> new HashMap());

    public RocketStationBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.inventory = new ItemStackHandler();
        this.itemCapability = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inventory});
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.registerAwardables(behaviours, new CreateAdvancement[]{AllAdvancements.CONTRAPTION_ACTORS});
    }

    public void destroy() {
        super.destroy();
        ItemHelper.dropContents((Level)this.level, (BlockPos)this.worldPosition, (IItemHandler)this.inventory);
    }

    public void queueAssembly(Player player) {
        this.owner = player;
        this.assembleNextTick = true;
    }

    public void enterAssembly() {
        this.assembleNextTick = true;
    }

    public void exitAssembly() {
        this.assembleNextTick = false;
    }

    public void tick() {
        super.tick();
        ++this.i;
        ItemStack item = this.container.getItem(0);
        if ((item.getItem() == NorthstarItems.STAR_MAP.get() || item.getItem() == NorthstarItems.RETURN_TICKET.get()) && item.has(NorthstarDataComponents.PLANET)) {
            this.target = NorthstarPlanets.getPlanetDimension((String)item.get(NorthstarDataComponents.PLANET));
        }
        this.fuelCost = this.fuelCalc();
        this.fuelReturnCost = this.fuelReturnCalc();
        if (this.assembleNextTick) {
            this.tryAssemble();
            this.assembleNextTick = false;
        }
    }

    private void tryAssemble() {
        BlockState blockState = this.getBlockState();
        if (!(blockState.getBlock() instanceof RocketStationBlock)) {
            return;
        }
        RocketContraption contraption = new RocketContraption();
        BlockEntity blockEntity = this.level.getBlockEntity(this.worldPosition);
        if (!(blockEntity instanceof RocketStationBlockEntity)) {
            return;
        }
        Direction movementDirection = Direction.UP;
        int engines = 0;
        boolean hasStation = false;
        float fuelAmount = 0.0f;
        int requiredJets = 0;
        int heatShielding = 0;
        double heatCost = 0.0;
        double heatCostHome = 0.0;
        try {
            this.lastException = null;
            contraption.owner = this.owner;
            if (!contraption.assemble(this.level, this.worldPosition)) {
                return;
            }
            engines = contraption.hasJetEngine();
            fuelAmount = contraption.fuelAmount();
            heatShielding = contraption.heatShielding();
            hasStation |= contraption.hasRocketStation();
            contraption.fuelCost = this.fuelCost;
            contraption.fuelReturnCost = this.fuelReturnCost;
            contraption.dest = this.target;
            heatCost = NorthstarTemperature.getHeatRating(this.target) * (double)contraption.blockCount + NorthstarTemperature.getHeatConstant(this.target);
            heatCostHome = NorthstarTemperature.getHeatRating((ResourceKey<Level>)this.level.dimension()) * (double)contraption.blockCount + NorthstarTemperature.getHeatConstant((ResourceKey<Level>)this.level.dimension());
            if (heatCostHome > heatCost) {
                heatCost = heatCostHome;
            }
            requiredJets = this.engineCalc();
            this.sendData();
        }
        catch (AssemblyException e) {
            this.owner.displayClientMessage((Component)Component.translatable((String)"northstar.gui.rocket_too_big").withStyle(ChatFormatting.RED), false);
            this.owner.displayClientMessage((Component)Component.translatable((String)"northstar.gui.current_config_size").withStyle(ChatFormatting.RED), false);
            this.owner.displayClientMessage((Component)Component.literal((String)((Integer)AllConfigs.server().kinetics.maxBlocksMoved.get()).toString()).withStyle(ChatFormatting.RED), false);
            this.lastException = e;
            this.sendData();
            return;
        }
        if (ContraptionCollider.isCollidingWithWorld((Level)this.level, (TranslatingContraption)contraption, (BlockPos)this.worldPosition.relative(movementDirection), (Direction)movementDirection)) {
            if (!this.level.getBlockState(this.worldPosition.above()).isAir()) {
                contraption.owner.displayClientMessage((Component)Component.literal((String)"Rocket Stations require at least 1 block of space above them").withStyle(ChatFormatting.RED), false);
            } else {
                contraption.owner.displayClientMessage((Component)Component.literal((String)"Something's blocking your rocket! Make sure everything is glued together!").withStyle(ChatFormatting.RED), false);
            }
            return;
        }
        Northstar.LOGGER.debug("Obamna");
        ProgressiveBlockSealer sealer = new ProgressiveBlockSealer(SealingMode.OXYGEN);
        ContraptionWorld contraptionWorld = new ContraptionWorld(this.level, (Contraption)contraption);
        int maximumSealedBlocks = (Integer)NorthstarConfigs.server().oxygenSealerMaxContraptionSealed.get();
        boolean oxygenSealed = sealer.beginSeal((Level)contraptionWorld, BlockPos.ZERO, Direction.UP) && sealer.updateSeal((Level)contraptionWorld, maximumSealedBlocks, maximumSealedBlocks) && !sealer.hasLeak();
        boolean interplanetaryFlag = NorthstarPlanets.isInterplanetary((ResourceKey<Level>)this.level.dimension(), this.target);
        if (interplanetaryFlag && contraption.hasInterplanetaryNavigation) {
            interplanetaryFlag = false;
        }
        if (interplanetaryFlag) {
            contraption.owner.displayClientMessage((Component)Component.literal((String)"Interplanetary travel requires a Interplanetary Navigator!").withStyle(ChatFormatting.RED), false);
        }
        if (engines >= requiredJets && hasStation && fuelAmount > (float)(this.fuelCost + contraption.weightCost) && (double)heatShielding >= heatCost && oxygenSealed && !interplanetaryFlag && contraption.hasControls && contraption.dest != null && contraption.dest != this.level.dimension()) {
            Northstar.LOGGER.debug("{}", (Object)engines);
            contraption.removeBlocksFromWorld(this.level, BlockPos.ZERO);
            RocketContraptionEntity movedContraption = RocketContraptionEntity.create(this.level, (Contraption)contraption);
            BlockPos anchor = this.worldPosition;
            movedContraption.setPos(anchor.getX(), anchor.getY(), anchor.getZ());
            AllSoundEvents.CONTRAPTION_ASSEMBLE.playOnServer(this.level, (Vec3i)this.worldPosition);
            movedContraption.destination = this.target;
            movedContraption.auto_land_mode = contraption.hasAutoLander;
            movedContraption.home = this.level.dimension();
            RocketHandler.ROCKETS.add(movedContraption);
            this.level.addFreshEntity((Entity)movedContraption);
        } else {
            contraption.owner.displayClientMessage((Component)Component.literal((String)("Full Fuel Cost: " + (contraption.weightCost + contraption.fuelCost))).withStyle(ChatFormatting.GOLD), false);
            contraption.owner.displayClientMessage((Component)Component.literal((String)("Current Fuel Supply: " + (int)contraption.fuelAmount())).withStyle(ChatFormatting.GOLD), false);
            contraption.owner.displayClientMessage((Component)Component.literal((String)("Estimated Return Cost: " + (contraption.weightCost + this.fuelReturnCost))).withStyle(ChatFormatting.GOLD), false);
            contraption.owner.displayClientMessage((Component)Component.literal((String)("Required Heat Shielding: " + heatCost)).withStyle(ChatFormatting.YELLOW), false);
            contraption.owner.displayClientMessage((Component)Component.literal((String)("Current Heat Shielding: " + contraption.heatShielding())).withStyle(ChatFormatting.YELLOW), false);
            contraption.owner.displayClientMessage((Component)Component.literal((String)("Required Engines: " + requiredJets)).withStyle(ChatFormatting.BLUE), false);
            contraption.owner.displayClientMessage((Component)Component.literal((String)("Current Engine Count: " + contraption.hasJetEngine())).withStyle(ChatFormatting.BLUE), false);
            if (!oxygenSealed) {
                contraption.owner.displayClientMessage((Component)Component.literal((String)"Cockpit is not sealed, or too large!").withStyle(ChatFormatting.DARK_RED), false);
            }
            if (contraption.fuelAmount() < (float)contraption.fuelCost) {
                contraption.owner.displayClientMessage((Component)Component.literal((String)"Insufficient fuel!").withStyle(ChatFormatting.DARK_RED), false);
            }
            if ((double)contraption.heatShielding() < heatCost) {
                contraption.owner.displayClientMessage((Component)Component.literal((String)"Insufficient heat shielding!").withStyle(ChatFormatting.DARK_RED), false);
            }
            if (contraption.hasJetEngine() < requiredJets) {
                contraption.owner.displayClientMessage((Component)Component.literal((String)"Not enough Jet Engines!").withStyle(ChatFormatting.DARK_RED), false);
            }
            if (!contraption.hasControls) {
                contraption.owner.displayClientMessage((Component)Component.literal((String)"No controls present!").withStyle(ChatFormatting.DARK_RED), false);
            }
            if (this.container.getItem(0).isEmpty()) {
                contraption.owner.displayClientMessage((Component)Component.literal((String)"No star map or ticket present!").withStyle(ChatFormatting.DARK_RED), false);
            } else if (contraption.dest == null || contraption.dest == this.level.dimension()) {
                contraption.owner.displayClientMessage((Component)Component.literal((String)"Invalid Target!").withStyle(ChatFormatting.DARK_RED), false);
            }
            contraption.owner.displayClientMessage((Component)Component.literal((String)"Rocket failed to assemble!").withStyle(ChatFormatting.RED), false);
            Northstar.LOGGER.debug("No station or jet engine, Bruh!");
            Northstar.LOGGER.debug("Heat Cost: {}     Heat Shielding: {}", (Object)heatCost, (Object)heatShielding);
            Northstar.LOGGER.debug("Weight Cost: {}      Fuel Cost: {}", (Object)contraption.weightCost, (Object)this.fuelCost);
            this.exception(new AssemblyException((Component)CreateLang.translateDirect((String)"train_assembly.no_controls", (Object[])new Object[0])), -1);
        }
    }

    public boolean isAssembling() {
        BlockState state = this.getBlockState();
        return state.hasProperty((Property)StationBlock.ASSEMBLING) && (Boolean)state.getValue((Property)StationBlock.ASSEMBLING) != false;
    }

    public int fuelCalc() {
        String home = NorthstarPlanets.getPlanetName((ResourceKey<Level>)this.level.dimension());
        String targ = NorthstarPlanets.getPlanetName(this.target);
        int home_x = (int)NorthstarPlanets.getPlanetX(home);
        int home_y = (int)NorthstarPlanets.getPlanetY(home);
        int targ_x = (int)NorthstarPlanets.getPlanetX(targ);
        int targ_y = (int)NorthstarPlanets.getPlanetY(targ);
        int dif = (int)(Math.pow(home_x - targ_x, 2.0) + Math.pow(home_y - targ_y, 2.0));
        dif = Mth.roundToward((int)dif, (int)100) / 20;
        int cost = dif + NorthstarPlanets.getPlanetAtmosphereCost((ResourceKey<Level>)this.level.dimension()) + 1000;
        return cost * 8;
    }

    public int fuelReturnCalc() {
        String home = NorthstarPlanets.getPlanetName((ResourceKey<Level>)this.level.dimension());
        String targ = NorthstarPlanets.getPlanetName(this.target);
        int home_x = (int)NorthstarPlanets.getPlanetX(home);
        int home_y = (int)NorthstarPlanets.getPlanetY(home);
        int targ_x = (int)NorthstarPlanets.getPlanetX(targ);
        int targ_y = (int)NorthstarPlanets.getPlanetY(targ);
        int dif = (int)(Math.pow(home_x - targ_x, 2.0) + Math.pow(home_y - targ_y, 2.0));
        dif = Mth.roundToward((int)dif, (int)100) / 20;
        int cost = dif + NorthstarPlanets.getPlanetAtmosphereCost(this.target) + 1000;
        return cost * 8;
    }

    public int engineCalc() {
        double homeConstant;
        double constant;
        double homeGrav;
        int homeAtmos = NorthstarPlanets.getPlanetAtmosphereCost((ResourceKey<Level>)this.level.dimension()) / 100;
        int targetAtmos = NorthstarPlanets.getPlanetAtmosphereCost(this.target) / 100;
        double grav = NorthstarPlanets.getGravMultiplier(this.target);
        if (grav < (homeGrav = NorthstarPlanets.getGravMultiplier((ResourceKey<Level>)this.level.dimension()))) {
            grav = homeGrav;
        }
        if ((constant = NorthstarPlanets.getEngineConstant(this.target)) < (homeConstant = NorthstarPlanets.getEngineConstant((ResourceKey<Level>)this.level.dimension()))) {
            constant = homeConstant;
        }
        return (int)(Mth.clamp((double)((double)(targetAtmos + homeAtmos) * grav), (double)6.0, (double)64.0) + constant);
    }

    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(tag, registries, clientPacket);
        tag.put("item", this.container.getItem(0).saveOptional(registries));
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        if (tag.contains("item", 10)) {
            this.container.setItem(0, ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound("item")));
        }
    }

    private void exception(AssemblyException exception, int carriage) {
        this.failedCarriageIndex = carriage;
        this.lastException = exception;
        this.sendData();
    }

    private boolean shouldAssemble() {
        BlockState blockState = this.getBlockState();
        return blockState.getBlock() instanceof RocketStationBlock;
    }

    public AssemblyException getLastAssemblyException() {
        return this.lastException;
    }

    public Direction getAssemblyDirection() {
        if (this.assemblyDirection != null) {
            return this.assemblyDirection;
        }
        if (!this.edgePoint.hasValidTrack()) {
            return null;
        }
        BlockPos targetPosition = this.edgePoint.getGlobalPosition();
        BlockState trackState = this.edgePoint.getTrackBlockState();
        ITrackBlock track = this.edgePoint.getTrack();
        Direction.AxisDirection axisDirection = this.edgePoint.getTargetDirection();
        Vec3 axis = ((Vec3)track.getTrackAxes((BlockGetter)this.level, targetPosition, trackState).get(0)).normalize().scale((double)axisDirection.getStep());
        this.assemblyDirection = Direction.getNearest((double)axis.x, (double)axis.y, (double)axis.z);
        return this.assemblyDirection;
    }

    public boolean isValid() {
        return !this.isRemoved();
    }

    public void attach(ControlledContraptionEntity contraption) {
        this.movedContraption = contraption;
        if (!this.level.isClientSide) {
            this.running = true;
            this.sendData();
        }
    }

    public boolean isAttachedTo(AbstractContraptionEntity contraption) {
        return this.movedContraption == contraption;
    }

    public BlockPos getBlockPosition() {
        return this.worldPosition;
    }

    public void onStall() {
        if (!this.level.isClientSide) {
            this.forceMove = true;
            this.sendData();
        }
    }

    public AbstractContainerMenu createMenu(int id, Inventory inv, Player player) {
        return RocketStationMenu.create(id, inv, this);
    }

    public Component getDisplayName() {
        return Component.literal((String)"Rocket Station");
    }
}

