/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.rocket_station;

import com.lightning.northstar.block.tech.rocket_station.RocketStationBlockEntity;
import com.lightning.northstar.content.NorthstarDataComponents;
import com.lightning.northstar.content.NorthstarItems;
import com.lightning.northstar.content.NorthstarMenuTypes;
import com.lightning.northstar.world.dimension.NorthstarPlanets;
import com.simibubi.create.foundation.gui.menu.MenuBase;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class RocketStationMenu
extends MenuBase<RocketStationBlockEntity> {
    public int fuelCost;
    public ResourceKey<Level> target;

    public RocketStationMenu(MenuType<?> type, int id, Inventory inv, RegistryFriendlyByteBuf extraData) {
        super(type, id, inv, extraData);
    }

    public RocketStationMenu(MenuType<?> type, int id, Inventory inv, RocketStationBlockEntity contentHolder) {
        super(type, id, inv, (Object)contentHolder);
    }

    public static AbstractContainerMenu create(int id, Inventory inv, RocketStationBlockEntity be) {
        return new RocketStationMenu((MenuType)NorthstarMenuTypes.ROCKET_STATION.get(), id, inv, be);
    }

    protected RocketStationBlockEntity createOnClient(RegistryFriendlyByteBuf extraData) {
        BlockEntity blockEntity = Minecraft.getInstance().level.getBlockEntity(extraData.readBlockPos());
        if (blockEntity instanceof RocketStationBlockEntity) {
            RocketStationBlockEntity be = (RocketStationBlockEntity)blockEntity;
            return be;
        }
        return null;
    }

    protected void initAndReadInventory(RocketStationBlockEntity contentHolder) {
    }

    protected void addSlots() {
        this.addSlot(new Slot(((RocketStationBlockEntity)((Object)this.contentHolder)).container, 0, 24, 47));
        this.addPlayerSlots(8, 84);
    }

    protected void saveData(RocketStationBlockEntity contentHolder) {
    }

    public int fuelCalc() {
        String home = NorthstarPlanets.getPlanetName((ResourceKey<Level>)((RocketStationBlockEntity)((Object)this.contentHolder)).getLevel().dimension());
        String targ = NorthstarPlanets.getPlanetName(this.target);
        int home_x = (int)NorthstarPlanets.getPlanetX(home);
        int home_y = (int)NorthstarPlanets.getPlanetY(home);
        int targ_x = (int)NorthstarPlanets.getPlanetX(targ);
        int targ_y = (int)NorthstarPlanets.getPlanetY(targ);
        int dif = (int)(Math.pow(home_x - targ_x, 2.0) + Math.pow(home_y - targ_y, 2.0));
        dif = Mth.roundToward((int)dif, (int)100) / 20;
        int cost = dif + NorthstarPlanets.getPlanetAtmosphereCost((ResourceKey<Level>)((RocketStationBlockEntity)((Object)this.contentHolder)).getLevel().dimension()) + 1000;
        return cost * 8;
    }

    public void slotsChanged(Container inventory) {
        ItemStack item = ((RocketStationBlockEntity)((Object)this.contentHolder)).container.getItem(0);
        if ((((RocketStationBlockEntity)((Object)this.contentHolder)).container.getItem(0).getItem() == NorthstarItems.STAR_MAP.get() || ((RocketStationBlockEntity)((Object)this.contentHolder)).container.getItem(0).getItem() == NorthstarItems.RETURN_TICKET.get()) && item.has(NorthstarDataComponents.PLANET)) {
            this.target = NorthstarPlanets.getPlanetDimension((String)item.get(NorthstarDataComponents.PLANET));
        }
        this.fuelCost = this.fuelCalc();
    }

    public ItemStack quickMoveStack(Player player, int index) {
        return ItemStack.EMPTY;
    }
}

