/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.rocket_station;

import com.google.common.collect.Lists;
import com.lightning.northstar.Northstar;
import com.lightning.northstar.block.tech.rocket_station.RocketStationBlockEntity;
import com.lightning.northstar.block.tech.rocket_station.RocketStationEditPacket;
import com.lightning.northstar.block.tech.rocket_station.RocketStationMenu;
import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.gui.element.ScreenElement;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RocketStationScreen
extends AbstractContainerScreen<RocketStationMenu>
implements ContainerListener {
    private static final ResourceLocation TABLE_LOCATION = Northstar.asResource("textures/gui/rocket_station.png");

    public RocketStationScreen(RocketStationMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
    }

    protected void init() {
        super.init();
        ((RocketStationMenu)this.menu).addSlotListener(this);
    }

    public void removed() {
        super.removed();
        ((RocketStationMenu)this.menu).removeSlotListener(this);
    }

    public void render(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderBackground(graphics, pMouseX, pMouseY, pPartialTick);
        super.render(graphics, pMouseX, pMouseY, pPartialTick);
        RenderSystem.disableBlend();
        this.renderFg(graphics, pMouseX, pMouseY, pPartialTick);
        this.renderButtons(graphics, pMouseX, pMouseY, pPartialTick);
        this.renderCost(graphics, pPartialTick);
        this.renderTooltip(graphics, pMouseX, pMouseY);
    }

    protected void renderCost(GuiGraphics pPoseStack, float delta) {
        ((RocketStationMenu)this.menu).slotsChanged(((RocketStationBlockEntity)((Object)((RocketStationMenu)this.menu).contentHolder)).container);
        int x = (this.width - (this.imageWidth + this.imageWidth / 2)) / 2;
        int y = (this.height - (this.imageHeight + this.imageHeight / 2)) / 2;
        if (((RocketStationMenu)this.menu).target != null) {
            pPoseStack.drawString(this.font, (Component)Component.literal((String)("Estimated Fuel Cost: " + ((RocketStationMenu)this.menu).fuelCost + " gJ")), x + this.imageWidth - 110, y + this.imageWidth - 100, 3226196);
        }
        if (((RocketStationMenu)this.menu).target == null) {
            pPoseStack.drawString(this.font, (Component)Component.literal((String)"Invalid Target"), x + this.imageWidth - 40, y + this.imageWidth - 100, 3226196);
        }
    }

    protected void renderButtons(GuiGraphics pPoseStack, int mouseX, int mouseY, float delta) {
        int x = (this.width - (this.imageWidth + this.imageWidth / 2)) / 2;
        int y = (this.height - (this.imageHeight + this.imageHeight / 2)) / 2;
        IconButton assemble = new IconButton(x + this.imageWidth - 10, y + this.imageHeight - 79, (ScreenElement)AllIcons.I_ADD);
        assemble.setToolTip((Component)CreateLang.translateDirect((String)"station.assemble_train", (Object[])new Object[0]));
        assemble.withCallback(() -> {
            CatnipServices.NETWORK.sendToServer((CustomPacketPayload)RocketStationEditPacket.tryAssemble(((RocketStationBlockEntity)((Object)((Object)((RocketStationMenu)this.menu).contentHolder))).getBlockPos()));
            this.removed();
            this.onClose();
        });
        assemble.render(pPoseStack, mouseX, mouseY, delta);
        this.addRenderableWidget((GuiEventListener)assemble);
        if (Math.abs(x + this.imageWidth - mouseX) < 9 && Math.abs(y + this.imageHeight - 79 + 9 - mouseY) < 9) {
            ArrayList list = Lists.newArrayList();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            list.add(Component.translatable((String)"northstar.gui.rocket_station.assemble"));
            pPoseStack.renderComponentTooltip(this.font, (List)list, mouseX, mouseY);
        }
    }

    protected void renderFg(GuiGraphics pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
    }

    protected void renderLabels(GuiGraphics pPoseStack, int pX, int pY) {
        RenderSystem.disableBlend();
        super.renderLabels(pPoseStack, pX, pY);
    }

    protected void renderBg(GuiGraphics graphics, float pPartialTick, int pMouseX, int pMouseY) {
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        graphics.blit(TABLE_LOCATION, i, j, 0, 0, this.imageWidth, this.imageHeight);
        graphics.blit(TABLE_LOCATION, i + 59, j + 20, 0, this.imageHeight + (((RocketStationMenu)this.menu).getSlot(0).hasItem() ? 0 : 16), 110, 16);
        if ((((RocketStationMenu)this.menu).getSlot(0).hasItem() || ((RocketStationMenu)this.menu).getSlot(1).hasItem()) && !((RocketStationMenu)this.menu).getSlot(2).hasItem()) {
            graphics.blit(TABLE_LOCATION, i + 99, j + 45, this.imageWidth, 0, 28, 21);
        }
    }

    public void dataChanged(AbstractContainerMenu pContainerMenu, int pDataSlotIndex, int pValue) {
    }

    public void slotChanged(AbstractContainerMenu pContainerToSend, int pSlotInd, ItemStack pStack) {
    }
}

