/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.telescope;

import com.google.common.collect.Lists;
import com.lightning.northstar.Northstar;
import com.lightning.northstar.block.tech.telescope.TelescopeBlockEntity;
import com.lightning.northstar.block.tech.telescope.TelescopeMenu;
import com.lightning.northstar.block.tech.telescope.TelescopePrintPacket;
import com.lightning.northstar.world.dimension.NorthstarDimensions;
import com.lightning.northstar.world.dimension.NorthstarPlanets;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.menu.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.gui.widget.IconButton;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.gui.element.ScreenElement;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TelescopeScreen
extends AbstractSimiContainerScreen<TelescopeMenu> {
    private static final ResourceLocation TELESCOPE_TEXTURE = Northstar.asResource("textures/gui/telescope_gui.png");
    private static final ResourceLocation TELESCOPE_TEXTURE_SIDE = Northstar.asResource("textures/gui/telescope_gui_side.png");
    private static final ResourceLocation MERCURY = Northstar.asResource("textures/environment/mercury_far.png");
    private static final ResourceLocation VENUS = Northstar.asResource("textures/environment/venus_far.png");
    private static final ResourceLocation EARTH = Northstar.asResource("textures/environment/earth_far.png");
    private static final ResourceLocation MOON = Northstar.asResource("textures/environment/moon_far.png");
    private static final ResourceLocation MARS = Northstar.asResource("textures/environment/mars_far.png");
    private static final ResourceLocation PHOBOS_DEIMOS = Northstar.asResource("textures/environment/phobos_and_deimos_far.png");
    private static final ResourceLocation CERES = Northstar.asResource("textures/environment/ceres_far.png");
    private static final ResourceLocation JUPITER = Northstar.asResource("textures/environment/jupiter_far.png");
    private static final ResourceLocation SATURN = Northstar.asResource("textures/environment/saturn_far.png");
    private static final ResourceLocation URANUS = Northstar.asResource("textures/environment/uranus_far.png");
    private static final ResourceLocation NEPTUNE = Northstar.asResource("textures/environment/neptune_far.png");
    private static final ResourceLocation PLUTO = Northstar.asResource("textures/environment/pluto_far.png");
    private static final ResourceLocation ERIS = Northstar.asResource("textures/environment/eris_far.png");
    private static final ResourceLocation BACKGROUND = Northstar.asResource("textures/environment/space_background.png");
    private static final ResourceLocation MOON_GLOW = ResourceLocation.parse((String)"textures/environment/moon_phases.png");
    private static final ResourceLocation MOON_FLAT = Northstar.asResource("textures/environment/moon_flat.png");
    private boolean isScrolling;
    private double scrollX = 450.0;
    private double scrollY = 450.0;
    private Inventory inv;
    public String selectedPlanet = null;

    public TelescopeScreen(TelescopeMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        this.inv = inv;
        this.imageWidth = 300;
        this.imageHeight = 300;
        this.titleLabelX = 150;
    }

    protected void init() {
        super.init();
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        IconButton printButton = new IconButton(x - 33, y + 200, (ScreenElement)AllIcons.I_ADD);
        printButton.withCallback(() -> {
            if (this.selectedPlanet != null) {
                CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new TelescopePrintPacket(((TelescopeBlockEntity)((Object)((Object)((TelescopeMenu)this.menu).contentHolder))).getBlockPos(), this.selectedPlanet));
            }
        });
        printButton.active = this.paperCheck();
        printButton.setToolTip((Component)Component.translatable((String)"northstar.gui.telescope.button_tooltip"));
        this.addRenderableWidget((GuiEventListener)printButton);
    }

    protected void renderLabels(GuiGraphics graphics, int pMouseX, int pMouseY) {
        graphics.drawString(this.font, this.title, this.titleLabelX - this.font.width((FormattedText)this.title) / 2, this.titleLabelY, 0x404040, false);
    }

    protected void renderBg(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        graphics.enableScissor(x + 3, y + 3, x + this.imageWidth - 3, y + this.imageHeight - 3);
        graphics.blit(BACKGROUND, x, y, (float)((int)(-this.scrollX)), (float)((int)(-this.scrollY)), this.imageWidth, this.imageHeight, 900, 900);
        this.renderPlanets(graphics, mouseX, mouseY, partialTick);
        graphics.disableScissor();
        graphics.blit(TELESCOPE_TEXTURE_SIDE, x - 174, y, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        graphics.blit(TELESCOPE_TEXTURE, x, y, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        this.renderTooltip(graphics, mouseX, mouseY);
        this.renderPlanetTooltips(graphics, mouseX, mouseY);
        this.renderSelectedPlanet(graphics);
    }

    public void renderPlanets(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        PoseStack pose = graphics.pose();
        ResourceKey player_dim = Minecraft.getInstance().player.level().dimension();
        if (player_dim != NorthstarDimensions.MARS_DIM_KEY) {
            int mars_x = (int)NorthstarPlanets.mars_x;
            int mars_y = (int)NorthstarPlanets.mars_y;
            pose.pushPose();
            pose.scale(0.05f, 0.05f, 0.05f);
            graphics.blit(MARS, mars_x * 20 + (int)this.scrollX * 20, mars_y * 20 + (int)this.scrollY * 20, 0, 0, 255, 255);
            pose.popPose();
            int pd_x = (int)NorthstarPlanets.pd_x;
            int pd_y = (int)NorthstarPlanets.pd_y;
            pose.pushPose();
            pose.scale(0.05f, 0.05f, 0.05f);
            graphics.blit(PHOBOS_DEIMOS, pd_x * 20 + (int)this.scrollX * 20, pd_y * 20 + (int)this.scrollY * 20, 0, 0, 255, 255);
            pose.popPose();
        }
        if (player_dim != NorthstarDimensions.VENUS_DIM_KEY) {
            int venus_x = (int)NorthstarPlanets.venus_x;
            int venus_y = (int)NorthstarPlanets.venus_y;
            pose.pushPose();
            pose.scale(0.05f, 0.05f, 0.05f);
            graphics.blit(VENUS, venus_x * 20 + (int)this.scrollX * 20, venus_y * 20 + (int)this.scrollY * 20, 0, 0, 255, 255);
            pose.popPose();
        }
        if (player_dim != NorthstarDimensions.MERCURY_DIM_KEY) {
            int mercury_x = (int)NorthstarPlanets.mercury_x;
            int mercury_y = (int)NorthstarPlanets.mercury_y;
            pose.pushPose();
            pose.scale(0.05f, 0.05f, 0.05f);
            graphics.blit(MERCURY, mercury_x * 20 + (int)this.scrollX * 20, mercury_y * 20 + (int)this.scrollY * 20, 0, 0, 255, 255);
            pose.popPose();
        }
        int jupiter_x = (int)NorthstarPlanets.jupiter_x;
        int jupiter_y = (int)NorthstarPlanets.jupiter_y;
        pose.pushPose();
        pose.scale(0.05f, 0.05f, 0.05f);
        graphics.blit(JUPITER, jupiter_x * 20 + (int)this.scrollX * 20, jupiter_y * 20 + (int)this.scrollY * 20, 0, 0, 255, 255);
        pose.popPose();
        int saturn_x = (int)NorthstarPlanets.saturn_x;
        int saturn_y = (int)NorthstarPlanets.saturn_y;
        pose.pushPose();
        pose.scale(0.05f, 0.05f, 0.05f);
        graphics.blit(SATURN, saturn_x * 20 + (int)this.scrollX * 20, saturn_y * 20 + (int)this.scrollY * 20, 0, 0, 255, 255);
        pose.popPose();
        int uranus_x = (int)NorthstarPlanets.uranus_x;
        int uranus_y = (int)NorthstarPlanets.uranus_y;
        pose.pushPose();
        pose.scale(0.05f, 0.05f, 0.05f);
        graphics.blit(URANUS, uranus_x * 20 + (int)this.scrollX * 20, uranus_y * 20 + (int)this.scrollY * 20, 0, 0, 255, 255);
        pose.popPose();
        int neptune_x = (int)NorthstarPlanets.neptune_x;
        int neptune_y = (int)NorthstarPlanets.neptune_y;
        pose.pushPose();
        pose.scale(0.05f, 0.05f, 0.05f);
        graphics.blit(NEPTUNE, neptune_x * 20 + (int)this.scrollX * 20, neptune_y * 20 + (int)this.scrollY * 20, 0, 0, 255, 255);
        pose.popPose();
        int pluto_x = (int)NorthstarPlanets.pluto_x;
        int pluto_y = (int)NorthstarPlanets.pluto_x;
        pose.pushPose();
        pose.scale(0.05f, 0.05f, 0.05f);
        graphics.blit(PLUTO, pluto_x * 20 + (int)this.scrollX * 20, pluto_y * 20 + (int)this.scrollY * 20, 0, 0, 255, 255);
        pose.popPose();
        int eris_x = (int)NorthstarPlanets.eris_x;
        int eris_y = (int)NorthstarPlanets.eris_y;
        pose.pushPose();
        pose.scale(0.05f, 0.05f, 0.05f);
        graphics.blit(ERIS, eris_x * 20 + (int)this.scrollX * 20, eris_y * 20 + (int)this.scrollY * 20, 0, 0, 255, 255);
        pose.popPose();
        if (player_dim != ClientLevel.OVERWORLD && player_dim != NorthstarDimensions.MOON_DIM_KEY) {
            int earth_x = (int)NorthstarPlanets.earth_x;
            int earth_y = (int)NorthstarPlanets.earth_y;
            pose.pushPose();
            pose.scale(0.05f, 0.05f, 0.05f);
            graphics.blit(EARTH, earth_x * 20 + (int)this.scrollX * 20, earth_y * 20 + (int)this.scrollY * 20, 0, 0, 255, 255);
            pose.popPose();
            int moon_x = (int)NorthstarPlanets.moon_x;
            int moon_y = (int)NorthstarPlanets.moon_y;
            pose.pushPose();
            pose.scale(0.05f, 0.05f, 0.05f);
            graphics.blit(MOON, moon_x * 20 + (int)this.scrollX * 20, moon_y * 20 + (int)this.scrollY * 20, 0, 0, 255, 255);
            pose.popPose();
        }
        if (player_dim == ClientLevel.OVERWORLD) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            pose.pushPose();
            pose.scale(2.0f, 1.0f, 1.0f);
            int moon_phase = Minecraft.getInstance().level.getMoonPhase();
            int moon_uv_x = moon_phase % 4 * 64;
            int moon_uv_y = moon_phase / 4 * 128;
            graphics.blit(MOON_GLOW, (int)NorthstarPlanets.earth_moon_x + (int)this.scrollX / 2 - 27, (int)NorthstarPlanets.earth_moon_y + (int)this.scrollY - 57, 0 + moon_uv_x, 0 + moon_uv_y, 64, 128);
            pose.popPose();
            pose.pushPose();
            RenderSystem.disableBlend();
            pose.scale(2.0f, 1.0f, 1.0f);
            graphics.blit(MOON_FLAT, (int)NorthstarPlanets.earth_moon_x + (int)this.scrollX / 2 - 27, (int)NorthstarPlanets.earth_moon_y + (int)this.scrollY - 57, 0 + moon_uv_x, 0 + moon_uv_y, 64, 128);
            pose.popPose();
        }
    }

    public boolean paperCheck() {
        if (this.inv.player.isCreative()) {
            return true;
        }
        boolean flag = false;
        if (this.inv != null) {
            for (int p = 0; p < 36; ++p) {
                ItemStack items = this.inv.getItem(p);
                Item item = items.getItem();
                if (item != Items.PAPER) continue;
                flag = true;
            }
        }
        return flag;
    }

    public void renderSelectedPlanet(GuiGraphics graphics) {
        if (this.selectedPlanet != null) {
            int x = (this.width - this.imageWidth) / 2;
            int y = (this.height - this.imageHeight) / 2;
            graphics.blit(this.getPlanetSprite(this.selectedPlanet), x - 40, y + 93, 0.0f, 0.0f, 35, 35, 35, 35);
            graphics.drawString(this.font, this.getPlanetName(this.selectedPlanet), x - 45, y + 130, 6944, false);
            graphics.drawString(this.font, "X: " + (int)NorthstarPlanets.getPlanetX(this.selectedPlanet), x - 45, y + 140, 6944, false);
            graphics.drawString(this.font, "Y: " + (int)NorthstarPlanets.getPlanetY(this.selectedPlanet), x - 45, y + 150, 6944, false);
        }
    }

    public void renderPlanetTooltips(GuiGraphics graphics, int mouseX, int mouseY) {
        int x = (this.width - (this.imageWidth + this.imageWidth / 2)) / 2;
        int y = (this.height - (this.imageHeight + this.imageHeight / 2)) / 2;
        ResourceKey player_dim = Minecraft.getInstance().player.level().dimension();
        if (Math.abs(NorthstarPlanets.mars_x + this.scrollX + 8.0 - (double)mouseX) < 8.0 && Math.abs(NorthstarPlanets.mars_y + this.scrollY + 8.0 - (double)mouseY) < 8.0 && player_dim != NorthstarDimensions.MARS_DIM_KEY) {
            ArrayList list = Lists.newArrayList();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            list.add(Component.translatable((String)"planets.mars.name").withStyle(ChatFormatting.AQUA));
            list.add(Component.translatable((String)"planets.mars.type").withStyle(ChatFormatting.GRAY));
            list.add(Component.translatable((String)"planets.mars.grav").withStyle(ChatFormatting.GRAY));
            list.add(Component.translatable((String)"planets.mars.temp").withStyle(ChatFormatting.GRAY));
            list.add(Component.translatable((String)"planets.mars.atmosphere").withStyle(ChatFormatting.GRAY));
            list.add(Component.literal((String)("X:  " + (int)NorthstarPlanets.mars_x)).withStyle(ChatFormatting.WHITE));
            list.add(Component.literal((String)("Y:  " + (int)NorthstarPlanets.mars_y)).withStyle(ChatFormatting.WHITE));
            graphics.renderComponentTooltip(this.font, (List)list, mouseX, mouseY);
        } else if (Math.abs(NorthstarPlanets.earth_x + this.scrollX + 8.0 - (double)mouseX) < 8.0 && Math.abs(NorthstarPlanets.earth_y + this.scrollY + 8.0 - (double)mouseY) < 8.0 && player_dim != ClientLevel.OVERWORLD) {
            ArrayList list = Lists.newArrayList();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            list.add(Component.translatable((String)"planets.earth.name").withStyle(ChatFormatting.AQUA));
            list.add(Component.translatable((String)"planets.earth.type").withStyle(ChatFormatting.GRAY));
            list.add(Component.translatable((String)"planets.earth.grav").withStyle(ChatFormatting.GRAY));
            list.add(Component.translatable((String)"planets.earth.temp").withStyle(ChatFormatting.GRAY));
            list.add(Component.translatable((String)"planets.earth.atmosphere").withStyle(ChatFormatting.GRAY));
            list.add(Component.literal((String)("X:  " + (int)NorthstarPlanets.earth_x)).withStyle(ChatFormatting.WHITE));
            list.add(Component.literal((String)("Y:  " + (int)NorthstarPlanets.earth_y)).withStyle(ChatFormatting.WHITE));
            graphics.renderComponentTooltip(this.font, (List)list, mouseX, mouseY);
        } else if (Math.abs(NorthstarPlanets.moon_x + this.scrollX + 8.0 - (double)mouseX) < 8.0 && Math.abs(NorthstarPlanets.moon_y + this.scrollY + 8.0 - (double)mouseY) < 8.0 && player_dim != ClientLevel.OVERWORLD && player_dim != NorthstarDimensions.MOON_DIM_KEY) {
            ArrayList list = Lists.newArrayList();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            list.add(Component.translatable((String)"planets.moon.name").withStyle(ChatFormatting.AQUA));
            list.add(Component.translatable((String)"planets.moon.type").withStyle(ChatFormatting.GRAY));
            list.add(Component.translatable((String)"planets.moon.grav").withStyle(ChatFormatting.GRAY));
            list.add(Component.translatable((String)"planets.moon.temp").withStyle(ChatFormatting.GRAY));
            list.add(Component.translatable((String)"planets.moon.atmosphere").withStyle(ChatFormatting.GRAY));
            list.add(Component.literal((String)("X:  " + (int)NorthstarPlanets.moon_x)).withStyle(ChatFormatting.WHITE));
            list.add(Component.literal((String)("Y:  " + (int)NorthstarPlanets.moon_y)).withStyle(ChatFormatting.WHITE));
            graphics.renderComponentTooltip(this.font, (List)list, mouseX, mouseY);
        } else if (Math.abs(NorthstarPlanets.pd_x + this.scrollX + 5.0 - (double)mouseX) < 5.0 && Math.abs(NorthstarPlanets.pd_y + this.scrollY + 5.0 - (double)mouseY) < 5.0 && player_dim != NorthstarDimensions.MARS_DIM_KEY) {
            ArrayList list = Lists.newArrayList();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            list.add(Component.translatable((String)"planets.phobos_deimos.name").withStyle(ChatFormatting.AQUA));
            list.add(Component.translatable((String)"planets.phobos_deimos.type").withStyle(ChatFormatting.GRAY));
            list.add(Component.translatable((String)"planets.phobos_deimos.grav").withStyle(ChatFormatting.GRAY));
            list.add(Component.translatable((String)"planets.phobos_deimos.temp").withStyle(ChatFormatting.GRAY));
            list.add(Component.translatable((String)"planets.phobos_deimos.atmosphere").withStyle(ChatFormatting.GRAY));
            list.add(Component.literal((String)("X:  " + (int)NorthstarPlanets.pd_x)).withStyle(ChatFormatting.WHITE));
            list.add(Component.literal((String)("Y:  " + (int)NorthstarPlanets.pd_y)).withStyle(ChatFormatting.WHITE));
            graphics.renderComponentTooltip(this.font, (List)list, mouseX, mouseY);
        } else if (Math.abs(NorthstarPlanets.venus_x + this.scrollX + 8.0 - (double)mouseX) < 8.0 && Math.abs(NorthstarPlanets.venus_y + this.scrollY + 8.0 - (double)mouseY) < 8.0 && player_dim != NorthstarDimensions.VENUS_DIM_KEY) {
            ArrayList list = Lists.newArrayList();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            list.add(Component.translatable((String)"planets.venus.name").withStyle(ChatFormatting.AQUA));
            list.add(Component.translatable((String)"planets.venus.type").withStyle(ChatFormatting.GRAY));
            list.add(Component.translatable((String)"planets.venus.grav").withStyle(ChatFormatting.GRAY));
            list.add(Component.translatable((String)"planets.venus.temp").withStyle(ChatFormatting.GRAY));
            list.add(Component.translatable((String)"planets.venus.atmosphere").withStyle(ChatFormatting.GRAY));
            list.add(Component.literal((String)("X:  " + (int)NorthstarPlanets.venus_x)).withStyle(ChatFormatting.WHITE));
            list.add(Component.literal((String)("Y:  " + (int)NorthstarPlanets.venus_y)).withStyle(ChatFormatting.WHITE));
            graphics.renderComponentTooltip(this.font, (List)list, mouseX, mouseY);
        } else if (Math.abs(NorthstarPlanets.mercury_x + this.scrollX + 7.0 - (double)mouseX) < 8.0 && Math.abs(NorthstarPlanets.mercury_y + this.scrollY + 7.0 - (double)mouseY) < 8.0 && player_dim != NorthstarDimensions.MERCURY_DIM_KEY) {
            ArrayList list = Lists.newArrayList();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            list.add(Component.translatable((String)"planets.mercury.name").withStyle(ChatFormatting.AQUA));
            list.add(Component.translatable((String)"planets.mercury.type").withStyle(ChatFormatting.GRAY));
            list.add(Component.translatable((String)"planets.mercury.grav").withStyle(ChatFormatting.GRAY));
            list.add(Component.translatable((String)"planets.mercury.temp").withStyle(ChatFormatting.GRAY));
            list.add(Component.translatable((String)"planets.mercury.atmosphere").withStyle(ChatFormatting.GRAY));
            list.add(Component.literal((String)("X:  " + (int)NorthstarPlanets.mercury_x)).withStyle(ChatFormatting.WHITE));
            list.add(Component.literal((String)("Y:  " + (int)NorthstarPlanets.mercury_y)).withStyle(ChatFormatting.WHITE));
            graphics.renderComponentTooltip(this.font, (List)list, mouseX, mouseY);
        } else if (Math.abs(NorthstarPlanets.earth_moon_x + this.scrollX - (double)mouseX) < 24.0 && Math.abs(NorthstarPlanets.earth_moon_y + this.scrollY - (double)mouseY) < 24.0 && player_dim == ClientLevel.OVERWORLD && player_dim != NorthstarDimensions.MOON_DIM_KEY) {
            ArrayList list = Lists.newArrayList();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            list.add(Component.translatable((String)"planets.moon.name").withStyle(ChatFormatting.AQUA));
            list.add(Component.translatable((String)"planets.moon.type").withStyle(ChatFormatting.GRAY));
            list.add(Component.translatable((String)"planets.moon.grav").withStyle(ChatFormatting.GRAY));
            list.add(Component.translatable((String)"planets.moon.temp").withStyle(ChatFormatting.GRAY));
            list.add(Component.translatable((String)"planets.moon.atmosphere").withStyle(ChatFormatting.GRAY));
            list.add(Component.literal((String)("X:  " + (int)NorthstarPlanets.earth_moon_x)).withStyle(ChatFormatting.WHITE));
            list.add(Component.literal((String)("Y:  " + (int)NorthstarPlanets.earth_moon_y)).withStyle(ChatFormatting.WHITE));
            graphics.renderComponentTooltip(this.font, (List)list, mouseX, mouseY);
        } else if (Math.abs(NorthstarPlanets.ceres_x + this.scrollX + 6.0 - (double)mouseX) < 6.0 && Math.abs(NorthstarPlanets.ceres_y + this.scrollY + 6.0 - (double)mouseY) < 6.0) {
            ArrayList list = Lists.newArrayList();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            list.add(Component.translatable((String)"planets.ceres.name").withStyle(ChatFormatting.AQUA));
            list.add(Component.translatable((String)"planets.ceres.type").withStyle(ChatFormatting.GRAY));
            list.add(Component.translatable((String)"planets.ceres.grav").withStyle(ChatFormatting.GRAY));
            list.add(Component.translatable((String)"planets.ceres.temp").withStyle(ChatFormatting.GRAY));
            list.add(Component.translatable((String)"planets.ceres.atmosphere").withStyle(ChatFormatting.GRAY));
            list.add(Component.literal((String)("X:  " + (int)NorthstarPlanets.ceres_x)).withStyle(ChatFormatting.WHITE));
            list.add(Component.literal((String)("Y:  " + (int)NorthstarPlanets.ceres_y)).withStyle(ChatFormatting.WHITE));
            graphics.renderComponentTooltip(this.font, (List)list, mouseX, mouseY);
        } else if (Math.abs(NorthstarPlanets.jupiter_x + this.scrollX + 12.0 - (double)mouseX) < 12.0 && Math.abs(NorthstarPlanets.jupiter_y + this.scrollY + 12.0 - (double)mouseY) < 12.0) {
            ArrayList list = Lists.newArrayList();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            list.add(Component.translatable((String)"planets.jupiter.name").withStyle(ChatFormatting.AQUA));
            list.add(Component.translatable((String)"planets.jupiter.type").withStyle(ChatFormatting.GRAY));
            list.add(Component.translatable((String)"planets.jupiter.grav").withStyle(ChatFormatting.GRAY));
            list.add(Component.translatable((String)"planets.jupiter.temp").withStyle(ChatFormatting.GRAY));
            list.add(Component.translatable((String)"planets.jupiter.atmosphere").withStyle(ChatFormatting.GRAY));
            list.add(Component.literal((String)("X:  " + (int)NorthstarPlanets.jupiter_x)).withStyle(ChatFormatting.WHITE));
            list.add(Component.literal((String)("Y:  " + (int)NorthstarPlanets.jupiter_x)).withStyle(ChatFormatting.WHITE));
            graphics.renderComponentTooltip(this.font, (List)list, mouseX, mouseY);
        } else if (Math.abs(NorthstarPlanets.saturn_x + this.scrollX + 8.0 - (double)mouseX) < 8.0 && Math.abs(NorthstarPlanets.saturn_y + this.scrollY + 8.0 - (double)mouseY) < 8.0) {
            ArrayList list = Lists.newArrayList();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            list.add(Component.translatable((String)"planets.saturn.name").withStyle(ChatFormatting.AQUA));
            list.add(Component.translatable((String)"planets.saturn.type").withStyle(ChatFormatting.GRAY));
            list.add(Component.translatable((String)"planets.saturn.grav").withStyle(ChatFormatting.GRAY));
            list.add(Component.translatable((String)"planets.saturn.temp").withStyle(ChatFormatting.GRAY));
            list.add(Component.translatable((String)"planets.saturn.atmosphere").withStyle(ChatFormatting.GRAY));
            list.add(Component.literal((String)("X:  " + (int)NorthstarPlanets.saturn_x)).withStyle(ChatFormatting.WHITE));
            list.add(Component.literal((String)("Y:  " + (int)NorthstarPlanets.saturn_y)).withStyle(ChatFormatting.WHITE));
            graphics.renderComponentTooltip(this.font, (List)list, mouseX, mouseY);
        } else if (Math.abs(NorthstarPlanets.uranus_x + this.scrollX + 8.0 - (double)mouseX) < 8.0 && Math.abs(NorthstarPlanets.uranus_y + this.scrollY + 8.0 - (double)mouseY) < 8.0) {
            ArrayList list = Lists.newArrayList();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            list.add(Component.translatable((String)"planets.uranus.name").withStyle(ChatFormatting.AQUA));
            list.add(Component.translatable((String)"planets.uranus.type").withStyle(ChatFormatting.GRAY));
            list.add(Component.translatable((String)"planets.uranus.grav").withStyle(ChatFormatting.GRAY));
            list.add(Component.translatable((String)"planets.uranus.temp").withStyle(ChatFormatting.GRAY));
            list.add(Component.translatable((String)"planets.uranus.atmosphere").withStyle(ChatFormatting.GRAY));
            list.add(Component.literal((String)("X:  " + (int)NorthstarPlanets.uranus_x)).withStyle(ChatFormatting.WHITE));
            list.add(Component.literal((String)("Y:  " + (int)NorthstarPlanets.uranus_y)).withStyle(ChatFormatting.WHITE));
            graphics.renderComponentTooltip(this.font, (List)list, mouseX, mouseY);
        } else if (Math.abs(NorthstarPlanets.neptune_x + this.scrollX + 8.0 - (double)mouseX) < 8.0 && Math.abs(NorthstarPlanets.neptune_y + this.scrollY + 8.0 - (double)mouseY) < 8.0) {
            ArrayList list = Lists.newArrayList();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            list.add(Component.translatable((String)"planets.neptune.name").withStyle(ChatFormatting.AQUA));
            list.add(Component.translatable((String)"planets.neptune.type").withStyle(ChatFormatting.GRAY));
            list.add(Component.translatable((String)"planets.neptune.grav").withStyle(ChatFormatting.GRAY));
            list.add(Component.translatable((String)"planets.neptune.temp").withStyle(ChatFormatting.GRAY));
            list.add(Component.translatable((String)"planets.neptune.atmosphere").withStyle(ChatFormatting.GRAY));
            list.add(Component.literal((String)("X:  " + (int)NorthstarPlanets.neptune_x)).withStyle(ChatFormatting.WHITE));
            list.add(Component.literal((String)("Y:  " + (int)NorthstarPlanets.neptune_y)).withStyle(ChatFormatting.WHITE));
            graphics.renderComponentTooltip(this.font, (List)list, mouseX, mouseY);
        } else if (Math.abs(NorthstarPlanets.pluto_x + this.scrollX + 6.0 - (double)mouseX) < 6.0 && Math.abs(NorthstarPlanets.pluto_y + this.scrollY + 6.0 - (double)mouseY) < 6.0) {
            ArrayList list = Lists.newArrayList();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            list.add(Component.translatable((String)"planets.pluto.name").withStyle(ChatFormatting.AQUA));
            list.add(Component.translatable((String)"planets.pluto.type").withStyle(ChatFormatting.GRAY));
            list.add(Component.translatable((String)"planets.pluto.grav").withStyle(ChatFormatting.GRAY));
            list.add(Component.translatable((String)"planets.pluto.temp").withStyle(ChatFormatting.GRAY));
            list.add(Component.translatable((String)"planets.pluto.atmosphere").withStyle(ChatFormatting.GRAY));
            list.add(Component.literal((String)("X:  " + (int)NorthstarPlanets.pluto_x)).withStyle(ChatFormatting.WHITE));
            list.add(Component.literal((String)("Y:  " + (int)NorthstarPlanets.pluto_y)).withStyle(ChatFormatting.WHITE));
            graphics.renderComponentTooltip(this.font, (List)list, mouseX, mouseY);
        } else if (Math.abs(NorthstarPlanets.eris_x + this.scrollX + 6.0 - (double)mouseX) < 6.0 && Math.abs(NorthstarPlanets.eris_y + this.scrollY + 6.0 - (double)mouseY) < 6.0) {
            ArrayList list = Lists.newArrayList();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            list.add(Component.translatable((String)"planets.eris.name").withStyle(ChatFormatting.AQUA));
            list.add(Component.translatable((String)"planets.eris.type").withStyle(ChatFormatting.GRAY));
            list.add(Component.translatable((String)"planets.eris.grav").withStyle(ChatFormatting.GRAY));
            list.add(Component.translatable((String)"planets.eris.temp").withStyle(ChatFormatting.GRAY));
            list.add(Component.translatable((String)"planets.eris.atmosphere").withStyle(ChatFormatting.GRAY));
            list.add(Component.literal((String)("X:  " + (int)NorthstarPlanets.eris_x)).withStyle(ChatFormatting.WHITE));
            list.add(Component.literal((String)("Y:  " + (int)NorthstarPlanets.eris_y)).withStyle(ChatFormatting.WHITE));
            graphics.renderComponentTooltip(this.font, (List)list, mouseX, mouseY);
        }
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (pButton != 0) {
            this.isScrolling = false;
            return false;
        }
        if (!this.isScrolling) {
            this.isScrolling = true;
        }
        this.scroll(pDragX, pDragY);
        return true;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int pButton) {
        if (pButton == 0 || pButton == 1) {
            if (Math.abs(NorthstarPlanets.mercury_x + this.scrollX + 7.0 - mouseX) < 8.0 && Math.abs(NorthstarPlanets.mercury_y + this.scrollY + 7.0 - mouseY) < 8.0 && Minecraft.getInstance().level.dimension() != NorthstarDimensions.MERCURY_DIM_KEY) {
                this.selectedPlanet = "mercury";
            }
            if (Math.abs(NorthstarPlanets.venus_x + this.scrollX + 8.0 - mouseX) < 8.0 && Math.abs(NorthstarPlanets.venus_y + this.scrollY + 8.0 - mouseY) < 8.0 && Minecraft.getInstance().level.dimension() != NorthstarDimensions.VENUS_DIM_KEY) {
                this.selectedPlanet = "venus";
            }
            if (Math.abs(NorthstarPlanets.earth_x + this.scrollX + 8.0 - mouseX) < 8.0 && Math.abs(NorthstarPlanets.earth_y + this.scrollY + 8.0 - mouseY) < 8.0 && Minecraft.getInstance().level.dimension() != Level.OVERWORLD) {
                this.selectedPlanet = "earth";
            }
            if (Math.abs(NorthstarPlanets.earth_moon_x + this.scrollX - mouseX) < 18.0 && Math.abs(NorthstarPlanets.earth_moon_y + this.scrollY - mouseY) < 18.0 && Minecraft.getInstance().level.dimension() == Level.OVERWORLD && Minecraft.getInstance().level.dimension() != NorthstarDimensions.MOON_DIM_KEY) {
                this.selectedPlanet = "earth_moon";
            }
            if (Math.abs(NorthstarPlanets.moon_x + this.scrollX + 8.0 - mouseX) < 8.0 && Math.abs(NorthstarPlanets.moon_y + this.scrollY + 8.0 - mouseY) < 8.0 && Minecraft.getInstance().level.dimension() != Level.OVERWORLD && Minecraft.getInstance().level.dimension() != NorthstarDimensions.MOON_DIM_KEY) {
                this.selectedPlanet = "moon";
            }
            if (Math.abs(NorthstarPlanets.mars_x + this.scrollX + 8.0 - mouseX) < 8.0 && Math.abs(NorthstarPlanets.mars_y + this.scrollY + 8.0 - mouseY) < 8.0 && Minecraft.getInstance().level.dimension() != NorthstarDimensions.MARS_DIM_KEY) {
                this.selectedPlanet = "mars";
            }
            if (Math.abs(NorthstarPlanets.ceres_x + this.scrollX + 8.0 - mouseX) < 8.0 && Math.abs(NorthstarPlanets.ceres_y + this.scrollY + 8.0 - mouseY) < 8.0) {
                this.selectedPlanet = "ceres";
            }
            if (Math.abs(NorthstarPlanets.jupiter_x + this.scrollX + 8.0 - mouseX) < 8.0 && Math.abs(NorthstarPlanets.jupiter_y + this.scrollY + 8.0 - mouseY) < 8.0) {
                this.selectedPlanet = "jupiter";
            }
            if (Math.abs(NorthstarPlanets.saturn_x + this.scrollX + 8.0 - mouseX) < 8.0 && Math.abs(NorthstarPlanets.saturn_y + this.scrollY + 8.0 - mouseY) < 8.0) {
                this.selectedPlanet = "saturn";
            }
            if (Math.abs(NorthstarPlanets.uranus_x + this.scrollX + 7.0 - mouseX) < 8.0 && Math.abs(NorthstarPlanets.uranus_y + this.scrollY + 7.0 - mouseY) < 8.0) {
                this.selectedPlanet = "uranus";
            }
            if (Math.abs(NorthstarPlanets.neptune_x + this.scrollX + 7.0 - mouseX) < 8.0 && Math.abs(NorthstarPlanets.neptune_y + this.scrollY + 7.0 - mouseY) < 8.0) {
                this.selectedPlanet = "neptune";
            }
            if (Math.abs(NorthstarPlanets.pluto_x + this.scrollX + 7.0 - mouseX) < 8.0 && Math.abs(NorthstarPlanets.pluto_y + this.scrollY + 7.0 - mouseY) < 8.0) {
                this.selectedPlanet = "pluto";
            }
            if (Math.abs(NorthstarPlanets.eris_x + this.scrollX + 7.0 - mouseX) < 8.0 && Math.abs(NorthstarPlanets.eris_y + this.scrollY + 7.0 - mouseY) < 8.0) {
                this.selectedPlanet = "eris";
            }
        }
        return super.mouseClicked(mouseX, mouseY, pButton);
    }

    public void scroll(double pDragX, double pDragY) {
        this.scrollX = Mth.clamp((double)(this.scrollX + pDragX), (double)0.0, (double)900.0);
        this.scrollY = Mth.clamp((double)(this.scrollY + pDragY), (double)0.0, (double)900.0);
    }

    public ResourceLocation getPlanetSprite(String planet) {
        return switch (planet) {
            case "mercury" -> MERCURY;
            case "venus" -> VENUS;
            case "earth" -> EARTH;
            case "earth_moon", "moon" -> MOON;
            case "mars" -> MARS;
            case "ceres" -> CERES;
            case "jupiter" -> JUPITER;
            case "saturn" -> SATURN;
            case "uranus" -> URANUS;
            case "neptune" -> NEPTUNE;
            case "pluto" -> PLUTO;
            case "eris" -> ERIS;
            default -> null;
        };
    }

    public Component getPlanetName(String planet) {
        return Component.translatable((String)("planets." + planet + ".name"));
    }
}

