/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.compat.jei.category;

import com.lightning.northstar.block.tech.ice_box.FreezingRecipe;
import com.lightning.northstar.compat.jei.animations.AnimatedIceBox;
import com.lightning.northstar.config.NorthstarConfigs;
import com.lightning.northstar.content.NorthstarBlocks;
import com.lightning.northstar.util.TemperatureUnit;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.item.ItemHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.createmod.catnip.data.Pair;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.apache.commons.lang3.mutable.MutableInt;

@ParametersAreNonnullByDefault
public class FreezingCategory
extends CreateRecipeCategory<FreezingRecipe> {
    private final AnimatedIceBox iceBox = new AnimatedIceBox();

    public FreezingCategory(CreateRecipeCategory.Info<FreezingRecipe> info) {
        super(info);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FreezingRecipe recipe, IFocusGroup focuses) {
        List condensedIngredients = ItemHelper.condenseIngredients((NonNullList)recipe.getIngredients());
        int size = condensedIngredients.size() + recipe.getFluidIngredients().size();
        int xOffset = size < 3 ? (3 - size) * 19 / 2 : 0;
        int i = 0;
        for (Pair pair : condensedIngredients) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (ItemStack itemStack : ((Ingredient)pair.getFirst()).getItems()) {
                ItemStack copy = itemStack.copy();
                copy.setCount(((MutableInt)pair.getSecond()).getValue().intValue());
                stacks.add(copy);
            }
            builder.addSlot(RecipeIngredientRole.INPUT, 17 + xOffset + i % 3 * 19, 20 - i / 3 * 19).setBackground(FreezingCategory.getRenderedSlot(), -1, -1).addItemStacks(stacks);
            ++i;
        }
        for (SizedFluidIngredient fluidIngredient : recipe.getFluidIngredients()) {
            FreezingCategory.addFluidSlot((IRecipeLayoutBuilder)builder, (int)(17 + xOffset + i % 3 * 19), (int)(20 - i / 3 * 19), (SizedFluidIngredient)fluidIngredient);
            ++i;
        }
        size = recipe.getRollableResults().size() + recipe.getFluidResults().size();
        i = 0;
        for (ProcessingOutput result : recipe.getRollableResults()) {
            int xPosition = 142 - (size % 2 != 0 && i == size - 1 ? 0 : (i % 2 == 0 ? 10 : -9));
            int yPosition = -19 * (i / 2) + 20;
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, xPosition, yPosition).setBackground(FreezingCategory.getRenderedSlot((ProcessingOutput)result), -1, -1).addItemStack(result.getStack())).addRichTooltipCallback(CreateRecipeCategory.addStochasticTooltip((ProcessingOutput)result));
            ++i;
        }
        for (FluidStack fluidResult : recipe.getFluidResults()) {
            int xPosition = 142 - (size % 2 != 0 && i == size - 1 ? 0 : (i % 2 == 0 ? 10 : -9));
            int yPosition = -19 * (i / 2) + 20;
            FreezingCategory.addFluidSlot((IRecipeLayoutBuilder)builder, (int)xPosition, (int)yPosition, (FluidStack)fluidResult);
            ++i;
        }
        builder.addSlot(RecipeIngredientRole.CATALYST, 153, 48).addItemStack(NorthstarBlocks.TEMPERATURE_REGULATOR.asStack());
    }

    public void draw(FreezingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        AllGuiTextures.JEI_SHADOW.render(graphics, 81, 38);
        this.iceBox.draw(graphics, 92, 41);
        MutableComponent text = recipe.getMaxTemperature() == Integer.MAX_VALUE ? Component.translatable((String)"northstar.recipe.freezing.hotter_than", (Object[])new Object[]{FreezingCategory.formatTemperature(recipe.getMinTemperature())}) : (recipe.getMinTemperature() == Integer.MIN_VALUE ? Component.translatable((String)"northstar.recipe.freezing.colder_than", (Object[])new Object[]{FreezingCategory.formatTemperature(recipe.getMaxTemperature())}) : Component.translatable((String)"northstar.recipe.freezing.within", (Object[])new Object[]{FreezingCategory.formatTemperature(recipe.getMinTemperature()), FreezingCategory.formatTemperature(recipe.getMaxTemperature())}));
        AllGuiTextures.JEI_NO_HEAT_BAR.render(graphics, 4, 47);
        graphics.drawString(Minecraft.getInstance().font, (Component)text, 9, 53, 0xFFFFFF);
    }

    private static String formatTemperature(int temperature) {
        return ((TemperatureUnit)((Object)NorthstarConfigs.client().temperatureUnit.get())).format(temperature);
    }
}

