/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.config;

import com.lightning.northstar.config.ClientConfig;
import com.lightning.northstar.config.CommonConfig;
import com.lightning.northstar.config.ServerConfig;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.createmod.catnip.config.ConfigBase;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class NorthstarConfigs {
    private static final Map<ModConfig.Type, ConfigBase> CONFIGS = new EnumMap<ModConfig.Type, ConfigBase>(ModConfig.Type.class);
    private static ClientConfig client;
    private static CommonConfig common;
    private static ServerConfig server;

    public static ClientConfig client() {
        return client;
    }

    public static CommonConfig common() {
        return common;
    }

    public static ServerConfig server() {
        return server;
    }

    public static ConfigBase byType(ModConfig.Type type) {
        return CONFIGS.get(type);
    }

    private static <T extends ConfigBase> T register(Supplier<T> factory, ModConfig.Type side) {
        Pair specPair = new ModConfigSpec.Builder().configure(builder -> {
            ConfigBase config = (ConfigBase)factory.get();
            config.registerAll(builder);
            return config;
        });
        ConfigBase config = (ConfigBase)specPair.getLeft();
        config.specification = (ModConfigSpec)specPair.getRight();
        CONFIGS.put(side, config);
        return (T)config;
    }

    public static void register(BiConsumer<ModConfig.Type, ModConfigSpec> register) {
        client = NorthstarConfigs.register(ClientConfig::new, ModConfig.Type.CLIENT);
        common = NorthstarConfigs.register(CommonConfig::new, ModConfig.Type.COMMON);
        server = NorthstarConfigs.register(ServerConfig::new, ModConfig.Type.SERVER);
        for (Map.Entry<ModConfig.Type, ConfigBase> pair : CONFIGS.entrySet()) {
            register.accept(pair.getKey(), pair.getValue().specification);
        }
    }

    public static void onLoad(ModConfig modConfig) {
        for (ConfigBase config : CONFIGS.values()) {
            if (config.specification != modConfig.getSpec()) continue;
            config.onLoad();
        }
    }

    public static void onReload(ModConfig modConfig) {
        for (ConfigBase config : CONFIGS.values()) {
            if (config.specification != modConfig.getSpec()) continue;
            config.onReload();
        }
    }
}

