/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.content;

import com.lightning.northstar.Northstar;
import com.lightning.northstar.content.NorthstarBlocks;
import com.lightning.northstar.content.NorthstarDataComponents;
import com.lightning.northstar.content.NorthstarItems;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyItem;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.tterrag.registrate.util.entry.RegistryEntry;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class NorthstarCreativeModeTab {
    public static final DeferredRegister<CreativeModeTab> CREATIVE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"northstar");
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> ITEMS = CREATIVE_TABS.register("items", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.northstar.items")).icon(() -> new ItemStack((ItemLike)NorthstarItems.MARTIAN_STEEL.get())).displayItems(NorthstarCreativeModeTab.createItemDisplay(ITEMS)).build());
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> BLOCKS = CREATIVE_TABS.register("blocks", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.northstar.blocks")).icon(() -> new ItemStack((ItemLike)NorthstarBlocks.MARTIAN_STEEL_BLOCK.get())).displayItems(NorthstarCreativeModeTab.createItemDisplay(BLOCKS)).build());
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> TECH = CREATIVE_TABS.register("tech", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.northstar.tech")).icon(() -> new ItemStack((ItemLike)NorthstarBlocks.TELESCOPE.get())).displayItems(NorthstarCreativeModeTab.createItemDisplay(TECH)).build());

    private static CreativeModeTab.DisplayItemsGenerator createItemDisplay(DeferredHolder<CreativeModeTab, CreativeModeTab> tab) {
        return (parameters, output) -> {
            Map<Item, Consumer<CreativeModeTab.Output>> builders = Map.of((Item)NorthstarItems.STAR_MAP.get(), out -> {
                NorthstarCreativeModeTab.registerStarMap(out, "earth");
                NorthstarCreativeModeTab.registerStarMap(out, "moon");
                NorthstarCreativeModeTab.registerStarMap(out, "mars");
                NorthstarCreativeModeTab.registerStarMap(out, "mercury");
                NorthstarCreativeModeTab.registerStarMap(out, "venus");
            }, (Item)NorthstarItems.IRON_SPACE_SUIT_CHESTPIECE.get(), out -> NorthstarCreativeModeTab.registerSpaceSuit(out, (Item)NorthstarItems.IRON_SPACE_SUIT_CHESTPIECE.get()), (Item)NorthstarItems.MARTIAN_STEEL_SPACE_SUIT_CHESTPIECE.get(), out -> NorthstarCreativeModeTab.registerSpaceSuit(out, (Item)NorthstarItems.MARTIAN_STEEL_SPACE_SUIT_CHESTPIECE.get()));
            for (RegistryEntry item : Northstar.REGISTRATE.getAll(Registries.ITEM)) {
                if (item.get() instanceof SequencedAssemblyItem || !CreateRegistrate.isInCreativeTab((RegistryEntry)item, (DeferredHolder)tab)) continue;
                output.accept((ItemLike)item.get(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
                Consumer<CreativeModeTab.Output> factory = builders.get(item.get());
                if (factory == null) continue;
                factory.accept(output);
            }
        };
    }

    private static void registerStarMap(CreativeModeTab.Output event, String planet) {
        ItemStack item = new ItemStack((ItemLike)NorthstarItems.STAR_MAP.get());
        item.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)("item.northstar.star_map_" + planet)).setStyle(Style.EMPTY.withColor(ChatFormatting.AQUA).withItalic(Boolean.valueOf(false))));
        item.set(NorthstarDataComponents.PLANET, (Object)planet);
        event.accept(item);
    }

    private static void registerSpaceSuit(CreativeModeTab.Output event, Item item) {
        ItemStack stack = new ItemStack((ItemLike)item);
        stack.set(NorthstarDataComponents.OXYGEN, (Object)1800);
        event.accept(stack);
    }

    public static void register(IEventBus eventBus) {
        CREATIVE_TABS.register(eventBus);
    }
}

