/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.contraption;

import com.lightning.northstar.content.NorthstarPackets;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import io.netty.buffer.ByteBuf;
import net.createmod.catnip.net.base.BasePacketPayload;
import net.createmod.catnip.net.base.ClientboundPacketPayload;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.apache.commons.lang3.tuple.MutablePair;

public class ActorConfigPacket
implements ClientboundPacketPayload {
    public static final StreamCodec<ByteBuf, ActorConfigPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, p -> p.contraptionId, (StreamCodec)BlockPos.STREAM_CODEC, p -> p.localPos, (StreamCodec)ByteBufCodecs.COMPOUND_TAG, p -> p.nbt, ActorConfigPacket::new);
    private final int contraptionId;
    private final BlockPos localPos;
    private final CompoundTag nbt;

    public ActorConfigPacket(int contraptionId, BlockPos localPos, CompoundTag nbt) {
        this.contraptionId = contraptionId;
        this.localPos = localPos;
        this.nbt = nbt;
    }

    public void handle(LocalPlayer localPlayer) {
        MutablePair actor;
        Entity entity = Minecraft.getInstance().level.getEntity(this.contraptionId);
        if (!(entity instanceof AbstractContraptionEntity)) {
            return;
        }
        AbstractContraptionEntity entity2 = (AbstractContraptionEntity)entity;
        Contraption contraption = entity2.getContraption();
        StructureTemplate.StructureBlockInfo block = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(this.localPos);
        if (block != null) {
            contraption.getBlocks().put(this.localPos, new StructureTemplate.StructureBlockInfo(block.pos(), block.state(), this.nbt));
        }
        if ((actor = contraption.getActorAt(this.localPos)) == null) {
            return;
        }
        Object object = ((MovementContext)actor.right).temporaryData;
        if (object instanceof ITakeConfig) {
            ITakeConfig config = (ITakeConfig)object;
            config.handleServerConfig(this.nbt);
        }
    }

    public BasePacketPayload.PacketTypeProvider getTypeProvider() {
        return NorthstarPackets.ACTOR_CONFIG;
    }

    public static interface ITakeConfig {
        public void handleServerConfig(CompoundTag var1);
    }
}

