/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.data.util;

import com.lightning.northstar.block.simple.GrateBlock;
import com.lightning.northstar.block.simple.VerticalSlabBlock;
import com.lightning.northstar.data.Tags;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.util.DataIngredient;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import java.util.function.Supplier;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;

public class NorthstarDataGenRecipes {
    public static NonNullBiConsumer<DataGenContext<Block, Block>, RegistrateRecipeProvider> plank(Tags.Tag<Item> log) {
        return NorthstarDataGenRecipes.plank(log.tag());
    }

    public static NonNullBiConsumer<DataGenContext<Block, Block>, RegistrateRecipeProvider> plank(TagKey<Item> log) {
        return (c, p) -> RegistrateRecipeProvider.planksFromLog((RecipeOutput)p, (ItemLike)((ItemLike)c.get()), (TagKey)log, (int)4);
    }

    public static NonNullBiConsumer<DataGenContext<Block, SlabBlock>, RegistrateRecipeProvider> slab(BlockEntry<Block> source) {
        return (c, p) -> {
            RegistrateRecipeProvider.slab((RecipeOutput)p, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, () -> ((SlabBlock)c.get()).asItem(), () -> ((Block)source.get()).asItem());
            p.stonecutting(DataIngredient.items((ItemLike)((Block)source.get()), (ItemLike[])new Block[0]), RecipeCategory.BUILDING_BLOCKS, (Supplier)c, 2);
        };
    }

    public static NonNullBiConsumer<DataGenContext<Block, VerticalSlabBlock>, RegistrateRecipeProvider> verticalSlab(BlockEntry<Block> source) {
        return (c, p) -> {
            Item material = ((Block)source.get()).asItem();
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)c.get()), (int)6).define(Character.valueOf('#'), (ItemLike)material).pattern("#").pattern("#").pattern("#").unlockedBy(RegistrateRecipeProvider.getHasName((ItemLike)material), RegistrateRecipeProvider.has((ItemLike)material)).save((RecipeOutput)p);
            p.stonecutting(DataIngredient.items((ItemLike)((Block)source.get()), (ItemLike[])new Block[0]), RecipeCategory.BUILDING_BLOCKS, (Supplier)c, 2);
        };
    }

    public static NonNullBiConsumer<DataGenContext<Block, StairBlock>, RegistrateRecipeProvider> stair(BlockEntry<Block> source) {
        return (c, p) -> {
            Item material = ((Block)source.get()).asItem();
            RegistrateRecipeProvider.stairBuilder(() -> ((StairBlock)c.get()).asItem(), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{material})).unlockedBy(RegistrateRecipeProvider.getHasName((ItemLike)material), RegistrateRecipeProvider.has((ItemLike)material)).save((RecipeOutput)p);
            p.stonecutting(DataIngredient.items((ItemLike)((Block)source.get()), (ItemLike[])new Block[0]), RecipeCategory.BUILDING_BLOCKS, (Supplier)c, 1);
        };
    }

    public static NonNullBiConsumer<DataGenContext<Block, WallBlock>, RegistrateRecipeProvider> wall(BlockEntry<Block> source) {
        return (c, p) -> {
            RegistrateRecipeProvider.wall((RecipeOutput)p, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, () -> ((WallBlock)c.get()).asItem(), () -> ((Block)source.get()).asItem());
            p.stonecutting(DataIngredient.items((ItemLike)((Block)source.get()), (ItemLike[])new Block[0]), RecipeCategory.BUILDING_BLOCKS, (Supplier)c, 1);
        };
    }

    public static NonNullBiConsumer<DataGenContext<Block, Block>, RegistrateRecipeProvider> sheetmetal(Tags.Tag<Item> sheet) {
        return NorthstarDataGenRecipes.sheetmetal(sheet.tag());
    }

    public static NonNullBiConsumer<DataGenContext<Block, Block>, RegistrateRecipeProvider> sheetmetal(TagKey<Item> sheet) {
        return NorthstarDataGenRecipes.commonFourToFour(sheet);
    }

    public static NonNullBiConsumer<DataGenContext<Block, Block>, RegistrateRecipeProvider> plating(Tags.Tag<Item> ingot) {
        return NorthstarDataGenRecipes.plating(ingot.tag());
    }

    public static NonNullBiConsumer<DataGenContext<Block, Block>, RegistrateRecipeProvider> plating(TagKey<Item> sheet) {
        return NorthstarDataGenRecipes.commonFourToFour(sheet);
    }

    public static <B extends Block> NonNullBiConsumer<DataGenContext<Block, B>, RegistrateRecipeProvider> commonFourToFour(TagKey<Item> tag) {
        return (c, p) -> {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)c.get()), (int)4).unlockedBy("has_item", RegistrateRecipeProvider.has((TagKey)tag)).define(Character.valueOf('#'), tag).pattern("##").pattern("##").save((RecipeOutput)p);
            p.stonecutting(DataIngredient.tag((TagKey)tag), RecipeCategory.BUILDING_BLOCKS, (Supplier)c, 1);
        };
    }

    public static NonNullBiConsumer<DataGenContext<Block, RotatedPillarBlock>, RegistrateRecipeProvider> pillar(Tags.Tag<Item> material) {
        return NorthstarDataGenRecipes.pillar(material.tag());
    }

    public static NonNullBiConsumer<DataGenContext<Block, RotatedPillarBlock>, RegistrateRecipeProvider> pillar(TagKey<Item> material) {
        return (c, p) -> {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)c.get()), (int)2).unlockedBy("has_item", RegistrateRecipeProvider.has((TagKey)material)).define(Character.valueOf('#'), material).pattern("#").pattern("#").save((RecipeOutput)p);
            p.stonecutting(DataIngredient.tag((TagKey)material), RecipeCategory.BUILDING_BLOCKS, (Supplier)c, 1);
        };
    }

    public static NonNullBiConsumer<DataGenContext<Block, RotatedPillarBlock>, RegistrateRecipeProvider> pillar(ItemLike material) {
        return (c, p) -> {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)c.get()), (int)2).unlockedBy("has_item", RegistrateRecipeProvider.has((ItemLike)material)).define(Character.valueOf('#'), material).pattern("#").pattern("#").save((RecipeOutput)p);
            p.stonecutting(DataIngredient.items((ItemLike)material, (ItemLike[])new ItemLike[0]), RecipeCategory.BUILDING_BLOCKS, (Supplier)c, 1);
        };
    }

    public static NonNullBiConsumer<DataGenContext<Block, Block>, RegistrateRecipeProvider> chiseled(ItemLike slab) {
        return (c, p) -> ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)c.get()), (int)1).unlockedBy("has_item", RegistrateRecipeProvider.has((ItemLike)slab)).define(Character.valueOf('#'), slab).pattern("#").pattern("#").save((RecipeOutput)p);
    }

    public static NonNullBiConsumer<DataGenContext<Block, GrateBlock>, RegistrateRecipeProvider> grate(Tags.Tag<Item> material) {
        return (c, p) -> ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)c.get()), (int)4).unlockedBy("has_item", RegistrateRecipeProvider.has(material.tag())).define(Character.valueOf('#'), material.tag()).pattern("###").pattern("# #").pattern("###").save((RecipeOutput)p);
    }
}

